<?php

use App\Http\Controllers\Api\Auth\AuthenticateController;
use App\Http\Controllers\Api\Platform\AccountNotificationSettingsController;
use App\Http\Controllers\Api\Platform\AccountPrivacySettingsController;
use App\Http\Controllers\Api\Platform\AffiliateProgramController;
use App\Http\Controllers\Api\Platform\AttributeController;
use App\Http\Controllers\Api\Platform\BusinessAffiliateController;
use App\Http\Controllers\Api\Platform\BusinessCategoryController;
use App\Http\Controllers\Api\Platform\BusinessController;
use App\Http\Controllers\Api\Platform\BusinessSubCategoryController;
use App\Http\Controllers\Api\Platform\CartItemController;
use App\Http\Controllers\Api\Platform\ChatController;
use App\Http\Controllers\Api\Platform\CommunityController;
use App\Http\Controllers\Api\Platform\DisputeController;
use App\Http\Controllers\Api\Platform\DisputeMessageController;
use App\Http\Controllers\Api\Platform\DisputeTypeController;
use App\Http\Controllers\Api\Platform\RealtimeMessageController;
use App\Http\Controllers\Api\Platform\CityController;
use App\Http\Controllers\Api\Platform\ContentRestrictionController;
use App\Http\Controllers\Api\Platform\CountryController;
use App\Http\Controllers\Api\Platform\CouponController;
use App\Http\Controllers\Api\Platform\CurrencyController;
use App\Http\Controllers\Api\Platform\ExternalAccountController;
use App\Http\Controllers\Api\Platform\FavoriteCategoryController;
use App\Http\Controllers\Api\Platform\OrderController;
use App\Http\Controllers\Api\Platform\OtpVerificationController;
use App\Http\Controllers\Api\Platform\PostController;
use App\Http\Controllers\Api\Platform\ProductController;
use App\Http\Controllers\Api\Platform\ProductRatingController;
use App\Http\Controllers\Api\Platform\ProfileSharingController;
use App\Http\Controllers\Api\Platform\ReportedProblemController;
use App\Http\Controllers\Api\Platform\SearchHistoryController;
use App\Http\Controllers\Api\Platform\SeriesController;
use App\Http\Controllers\Api\Platform\SeriesSeasonController;
use App\Http\Controllers\Api\Platform\StorageFileController;
use App\Http\Controllers\Api\Platform\TestController;
use App\Http\Controllers\Api\Platform\UserController;
use App\Http\Controllers\Api\Platform\UserDeviceController;
use App\Http\Controllers\Api\Platform\UserEmailController;
use App\Http\Controllers\Api\Platform\UserTelephoneController;
use App\Http\Controllers\Api\Platform\UserVerificationController;
use App\Http\Controllers\Api\Platform\WalletController;
use Illuminate\Support\Facades\Route;
use Illuminate\Routing\Router;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::group(['prefix' => 'v1', 'middleware' => 'lang'], function (Router $router) {
   require __DIR__ . '/api.auth.php';

   /**
    * Protected routes
    */
   $router->group(['middleware' => ['auth:sanctum', 'handle-timezone']], function (Router $router) {
      /**
       * Users
       */
      $router->group(['prefix' => 'users'], function (Router $router) {
         $router->get('', [AuthenticateController::class, 'user']);
         $router->post('add/interest', [UserController::class, 'saveInterest']);
         $router->get('subscribable', [UserController::class, 'subscribable']);
         $router->put('configure-account', [UserController::class, 'configAccount']);
         $router->get('most-used-hashtags', [UserController::class, 'mostUsedHashTag']);
         $router->post('change-phone-number', [UserController::class, 'changePrimaryPhoneNumber']);
         $router->post('change-email', [UserController::class, 'changePrimaryEmail']);
         $router->post('change-password', [UserController::class, 'changePassword']);
         $router->post('follow', [UserController::class, 'followUser']);
         $router->delete('delete', [UserController::class, 'deleteAccount']);
         $router->post('discover', [UserController::class, 'discover']);
         $router->get('reviews', [UserController::class, 'reviews'])->middleware('has-business');

         /**
          * Search
          */
         $router->get('search', [SearchHistoryController::class, 'search']);
         $router->get('search/for-mention', [UserController::class, 'lookingUsersToIdentify']);

         /**
          * Blocked accounts
          */
         $router->get('blocked-accounts', [UserController::class, 'userBlockedAccounts']);
         $router->get('blocked-accounts/search', [UserController::class, 'searchBlockedAccounts']);
         $router->post('blocked-accounts/add', [UserController::class, 'blockAccount']);
         $router->post('blocked-accounts/unblock', [UserController::class, 'unblockAccount']);

         /**
          * Visitor profile
          */
         $router->get('{userId}/visitor-profile', [UserController::class, 'visitorProfile']);
         $router->get('{userId}/visitor-profile/posts', [UserController::class, 'visitorProfilePost']);
         $router->get('{userId}/visitor-profile/posts/saves', [UserController::class, 'visitorProfileSavedPosts']);
         $router->get('{userId}/visitor-profile/posts/share', [UserController::class, 'visitorProfileSharedPosts']);
         $router->get('{userId}/visitor-profile/posts/likes', [UserController::class, 'visitorProfileLikedPosts']);
         $router->get('{userId}/visitor-profile/followers', [UserController::class, 'userFollowers']);
         $router->get('{userId}/visitor-profile/followings', [UserController::class, 'userFollowings']);
         $router->get('{userId}/visitor-profile/reviews', [UserController::class, 'userReviews']);
         $router->get('{userId}/visitor-profile/suggestions', [UserController::class, 'visitorSuggestions']);

         /**
          * Profile
          */
         $router->get('profile', [UserController::class, 'profile']);
         $router->get('profile/posts', [UserController::class, 'getUsersPosts']);
         $router->get('profile/posts/saves', [UserController::class, 'getUsersPostsFavorite']);
         $router->get('profile/posts/share', [UserController::class, 'getUsersSharePosts']);
         $router->post('profile/edit', [UserController::class, 'editProfile']);

         /**
          * User followers
          */
         $router->get('followers', [UserController::class, 'getFollowers']);
         $router->get('followers/search', [UserController::class, 'searchFollowers']);
         $router->post('followers/delete', [UserController::class, 'deleteFollower']);

         /**
          * User following
          */
         $router->get('followings', [UserController::class, 'getFollowings']);
         $router->get('followings/search', [UserController::class, 'searchFollowings']);
      });

      /**
       * Wallet
       */
      $router->group(['prefix' => 'wallets', 'middleware' => ['is-verified-user', 'is-wallet-blocked']], function (Router $router) {
         $router->get('status', [WalletController::class, 'walletStatus'])->withoutMiddleware('is-wallet-blocked');
         $router->post('set-pin', [WalletController::class, 'setPin']);
         $router->post('update-pin', [WalletController::class, 'updatePin']);
         $router->post('check-pin', [WalletController::class, 'checkPin']);
         $router->post('find-for-transaction', [WalletController::class, 'findByWalletNumber'])->withoutMiddleware('is-wallet-blocked');
         $router->post('transfer', [WalletController::class, 'transferToAccount']);
         $router->post('deposit', [WalletController::class, 'deposit']);
         $router->post('withdraw', [WalletController::class, 'withdrawal']);
         $router->get('transactions', [WalletController::class, 'transactions'])->withoutMiddleware('is-wallet-blocked');
      });

      /**
       * External account
       */
      $router->group(['prefix' => 'external-accounts', 'middleware' => 'is-verified-user'], function (Router $router) {
         $router->post('configure', [ExternalAccountController::class, 'configureAccount']);
         $router->post('edit', [ExternalAccountController::class, 'editAccount']);
         $router->post('accounts', [ExternalAccountController::class, 'userAccounts']);
      });

      /**
       * User verification
       */
      $router->group(['prefix' => 'user-verifications'], function (Router $router) {
         $router->post('request', [UserVerificationController::class, 'requestVerification']);
         $router->get('check', [UserVerificationController::class, 'checkStatus']);
      });

      /**
       * User device
       */
      $router->group(['prefix' => 'devices'], function (Router $router) {
         $router->delete('/replace', [UserDeviceController::class, 'replaceDevice']);
      });

      /**
       * Cities
       */
      $router->group(['prefix' => 'cities'], function (Router $router) {
         $router->post('create', [CityController::class, 'create']);
         $router->post('get-by-country', [CityController::class, 'getByCountry']);
      });

      /**
       * Business sub categories
       */
      $router->group(['prefix' => 'business-sub-categories', 'middleware' => 'has-business'], function (Router $router) {
         $router->get('interests', [BusinessSubCategoryController::class, 'allInterests'])->withoutMiddleware('has-business');
         $router->get('get-by-category', [BusinessSubCategoryController::class, 'getByCategory']);
      });

      /**
       * Business categories
       */
      $router->group(['prefix' => 'business-categories'], function (Router $router) {
         $router->get('/', [BusinessCategoryController::class, 'businessCategories']);
      });

      /**
       * Businesses
       */
      $router->group(['prefix' => 'businesses', 'middleware' => 'is-verified-user'], function (Router $router) {
         $router->post('create', [BusinessController::class, 'create']);
         $router->get('shop', [BusinessController::class, 'productsShop']);
         $router->get('profile/posts', [BusinessController::class, 'getBusinessPosts'])->middleware('has-business');
         $router->get('shop-for-visitor', [BusinessController::class, 'productForVisitorShop']);
      });

      /**
       * Attributes
       */
      $router->group(['prefix' => 'attributes', 'middleware' => ['is-verified-user', 'has-business']], function (Router $router) {
         $router->get('business', [AttributeController::class, 'getBusinessAttributes']);
         $router->get('base', [AttributeController::class, 'getBaseAttributes']);
         $router->post('custom/create', [AttributeController::class, 'createCustomAttribute']);
      });

      /**
       * Products
       */
      $router->group(['prefix' => 'products', 'middleware' => ['is-verified-user', 'has-business']], function (Router $router) {
         $router->post('goods/add', [ProductController::class, 'addGoods']);
         $router->post('service/add', [ProductController::class, 'addService']);
         $router->post('cinema/add', [ProductController::class, 'addCinema']);
         $router->post('music/add', [ProductController::class, 'addMusic']);
         $router->post('library/add', [ProductController::class, 'addLibrary']);
         $router->post('game/add', [ProductController::class, 'addGame']);

         $router->get('{productId}/details/for-visitor', [ProductController::class, 'productDetailsForVisitor'])->withoutMiddleware('has-business');
         $router->get('{productId}/similar-to-another', [ProductController::class, 'similarProductsToAnother'])->withoutMiddleware('has-business');
         $router->put('update-status-to-complete', [ProductController::class, 'updateStatusToComplete']);

         $router->get('{productId}/ratings', [ProductRatingController::class, 'productRatingsHistory'])->withoutMiddleware('has-business');
         $router->post('review', [ProductRatingController::class, 'createOrUpdate'])->withoutMiddleware('has-business');
         $router->get('sample', [ProductController::class, 'sampleProducts'])->withoutMiddleware('has-business');

         $router->post('add-to-cart', [CartItemController::class, 'create'])->withoutMiddleware('has-business');
         $router->get('resume-cart', [CartItemController::class, 'resume'])->withoutMiddleware('has-business');
         $router->post('update-cart', [CartItemController::class, 'update'])->withoutMiddleware('has-business');
      });

      /**
       * Cart
       */
      $router->group(['prefix' => 'carts', 'middleware' => ['is-verified-user']], function (Router $router) {
         $router->get('status', [CartItemController::class, 'status']);
      });

      /**
       * Affiliate programs
       */
      $router->group(['prefix' => 'affiliation-programs', 'middleware' => ['is-verified-user', 'has-business', 'handle-timezone']], function (Router $router) {
         $router->get('affiliates', [AffiliateProgramController::class, 'businessAffiliates']);
         $router->post('create', [AffiliateProgramController::class, 'createProgram']);
         $router->get('available-programs', [AffiliateProgramController::class, 'availablePrograms']);
      });

      /**
       * Business affiliates
       */
      $router->group(['prefix' => 'business-affiliates', 'middleware' => ['is-verified-user', 'has-business']], function (Router $router) {
         $router->post('affiliate-to-program', [BusinessAffiliateController::class, 'affiliateToProgram']);
         $router->get('affiliated-programs', [BusinessAffiliateController::class, 'affiliatedPrograms']);
      });

      /**
       * Post
       */
      $router->group(['prefix' => 'posts'], function (Router $router) {
         $router->post('create', [PostController::class, 'createPost']);
         $router->post('republish', [PostController::class, 'republish']);
         $router->get('feeds', [PostController::class, 'postFeeds']);
         $router->post('like', [PostController::class, 'likePost']);
         $router->post('save', [PostController::class, 'savePost']);
         $router->post('share', [PostController::class, 'sharePost']);
         $router->post('comment', [PostController::class, 'commentPost']);
         $router->get('{postId}', [PostController::class, 'postDetails']);
         $router->get('{postId}/comments', [PostController::class, 'postComments']);
         $router->put('turn-on-comment', [PostController::class, 'turnOnComment']);
         $router->delete('delete', [PostController::class, 'deletePost']);
      });

      /**
       * Post comments
       */
      $router->group(['prefix' => 'post-comments'], function (Router $router) {
         $router->post('reply', [PostController::class, 'commentReply']);
      });

      /**
       * Orders
       */
      $router->group(['prefix' => 'orders', 'middleware' => ['is-verified-user', 'handle-timezone']], function (Router $router) {
         $router->get('', [OrderController::class, 'list']);
         $router->post('add', [OrderController::class, 'add']);
         $router->post('validate', [OrderController::class, 'validateOrder'])->middleware('has-business');
         $router->post('proceed-to-payment', [OrderController::class, 'pay']);
         $router->post('confirm-delivery', [OrderController::class, 'confirmDelivery']);
         $router->post('cancel', [OrderController::class, 'cancel']);
         $router->get('{id}/details', [OrderController::class, 'orderDetails']);

         $router->post('movie/buy', [OrderController::class, 'buyMovie']);
         $router->post('series/buy', [OrderController::class, 'buySeries']);
         $router->post('book/buy', [OrderController::class, 'buyBook']);
         $router->post('music/buy', [OrderController::class, 'buyMusic']);
         $router->post('music-album/buy', [OrderController::class, 'buyMusicAlbum']);
         $router->post('game/buy', [OrderController::class, 'buyGame']);

         $router->get('purchases', [OrderController::class, 'purchases']);
         $router->get('sales', [OrderController::class, 'sales'])->middleware('has-business');
         $router->post('compute-coupon-amount', [OrderController::class, 'computeCouponAmount']);
      });

      /**
       * Series
       */
      $router->group(['prefix' => 'series', 'middleware' => ['is-verified-user']], function (Router $router) {
         $router->get('{seriesId}/seasons', [SeriesController::class, 'seasons']);
         $router->get('seasons/{seasonId}/episodes', [SeriesSeasonController::class, 'episodes']);
      });

      /**
       * Favourite categories
       */
      $router->group(['prefix' => 'favorite-categories', 'middleware' => ['is-verified-user']], function (Router $router) {
         $router->post('create', [FavoriteCategoryController::class, 'create']);
         $router->get('', [FavoriteCategoryController::class, 'getCategories']);
         $router->post('update', [FavoriteCategoryController::class, 'updateCategory']);
         $router->post('delete', [FavoriteCategoryController::class, 'deleteCategory']);
      });

      /**
       * Coupons
       */
      $router->group(['prefix' => 'coupons', 'middleware' => ['is-verified-user', 'has-business', 'handle-timezone']], function (Router $router) {
         $router->get('discount-types', [CouponController::class, 'discountTypes'])->withoutMiddleware('has-business');
         $router->post('create', [CouponController::class, 'create']);
         $router->get('statistics', [CouponController::class, 'statistics']);
         $router->post('compute-coupon-fees', [CouponController::class, 'computeCouponFees']);
      });

      /**
       * Otp
       */
      $router->group(['prefix' => 'otp'], function (Router $router) {
         $router->post('send-for-verification', [OtpVerificationController::class, 'sendForVerification']);
         $router->post('single-verification', [OtpVerificationController::class, 'singleVerification']);
      });

      /**
       * Two factors auth
       */
      $router->group(['prefix' => '2factor-auth'], function (Router $router) {
         $router->post('send-code', [OtpVerificationController::class, 'send2FactorAuthCode']);
         $router->post('verify-code', [OtpVerificationController::class, 'verify2FactorAuthCode']);
      });

      /**
       * Telephone
       */
      $router->group(['prefix' => 'telephones'], function (Router $router) {
         $router->get('', [UserTelephoneController::class, 'getAll']);
         $router->post('add', [UserTelephoneController::class, 'add']);
         $router->post('edit', [UserTelephoneController::class, 'edit']);
         $router->post('mark-as-primary', [UserTelephoneController::class, 'markPrimary']);
         $router->post('deactivate', [UserTelephoneController::class, 'deactivate']);
         $router->delete('delete', [UserTelephoneController::class, 'delete']);
         $router->post('verify', [UserTelephoneController::class, 'verify']);
      });

      /**
       * Emails
       */
      $router->group(['prefix' => 'emails'], function (Router $router) {
         $router->get('', [UserEmailController::class, 'getAll']);
         $router->post('add', [UserEmailController::class, 'add']);
         $router->post('edit', [UserEmailController::class, 'edit']);
         $router->post('verify', [UserEmailController::class, 'verify']);
         $router->delete('delete', [UserEmailController::class, 'delete']);
      });

      /**
       * Account Privacy Settings
       */
      $router->group(['prefix' => 'account-privacy-settings'], function (Router $router) {
         $router->get('', [AccountPrivacySettingsController::class, 'index']);
         $router->post('edit', [AccountPrivacySettingsController::class, 'edit']);
         $router->put('2factor', [AccountPrivacySettingsController::class, 'enableOrDisable2factorAuth']);
      });

      /**
       * Profile sharing
       */
      $router->group(['prefix' => 'profile-sharing'], function (Router $router) {
         $router->get('', [ProfileSharingController::class, 'profileSharing']);
         $router->post('add', [ProfileSharingController::class, 'add']);
      });

      /**
       * Account notification settings
       */
      $router->group(['prefix' => 'account-notification-settings'], function (Router $router) {
         $router->get('', [AccountNotificationSettingsController::class, 'index']);
         $router->post('edit', [AccountNotificationSettingsController::class, 'edit']);
      });

      /**
       * Content restrictions
       */
      $router->group(['prefix' => 'content-restrictions'], function (Router $router) {
         $router->post('add', [ContentRestrictionController::class, "add"]);
         $router->get('', [ContentRestrictionController::class, 'getRestrictions']);
         $router->delete('delete', [ContentRestrictionController::class, 'delete']);
      });

      /**
       * Search Histories
       */
      $router->group(['prefix' => 'search-histories'], function (Router $router) {
         $router->get('', [SearchHistoryController::class, 'getHistories']);
         $router->delete('delete', [SearchHistoryController::class, 'deleteHistory']);
      });

      /**
       * Reported problems
       */
      $router->group(['prefix' => 'reported-problems'], function (Router $router) {
         $router->post('add', [ReportedProblemController::class, 'add']);
      });

      /**
       * Share routes
       */
      $router->group(['prefix' => 'share'], function (Router $router) {
         $router->get('posts', [PostController::class, 'postDetails'])->name('posts.share');
      });

      /**
       * Chat feature
       */
      $router->group(['prefix' => 'chats'], function (Router $router) {
         $router->get('history', [ChatController::class, 'history']);

         /**
          * Chat message route
          */
         $router->group(['prefix' => 'messages'], function (Router $router) {
            $router->post('send', [RealtimeMessageController::class, 'newMessage']);
            $router->put('mark-as-delivered', [RealtimeMessageController::class, 'markAsDelivered']);
            $router->put('mark-as-read', [RealtimeMessageController::class, 'markAsRead']);
            $router->get('{uuid}', [RealtimeMessageController::class, 'getMessage']);
         });
      });

      /**
       * Chat feature
       */
      $router->group(['prefix' => 'disputes'], function (Router $router) {
         $router->post('create', [DisputeController::class, 'create']);
         $router->get('history', [DisputeController::class, 'history']);
         $router->get('{uuid}', [DisputeController::class, 'getDispute']);

         /**
          * Chat message route
          */
         $router->group(['prefix' => 'messages'], function (Router $router) {
            $router->post('send', [DisputeMessageController::class, 'newMessage']);
         });
      });

      /**
       * Communities
       */
      $router->group(['prefix' => 'communities', 'middleware' => ['handle-timezone']], function (Router $router) {
         $router->get('', [CommunityController::class, 'usersCommunities']);
         $router->get('suggestions', [CommunityController::class, 'communitySuggestions']);
         $router->post('create', [CommunityController::class, 'create']);
         $router->get('{communityId}/posts/feed', [CommunityController::class, 'getCommunityFeeds']);
         $router->get('{communityId}/membership-requests', [CommunityController::class, 'memberRequests']);
         $router->post('edit', [CommunityController::class, 'edit']);
         $router->put('{communityId}/settings/edit', [CommunityController::class, 'editSetting']);
         $router->delete('{communityId}/delete', [CommunityController::class, 'deleteCommunity']);
         $router->post('report', [CommunityController::class, 'addReport']);
         $router->get('{communityId}/reports', [CommunityController::class, 'getCommunityReports']);

         $router->group(['prefix' => 'subscribers'], function (Router $router) {
            $router->post('add', [CommunityController::class, 'addSubscriber']);
            $router->post('mark-as-admin', [CommunityController::class, 'markAsAdmin']);
            $router->post('mark-as-simple-member', [CommunityController::class, 'markAsMember']);
            $router->delete('remove', [CommunityController::class, 'deleteSubscriber']);
            $router->delete('leave', [CommunityController::class, 'leaveCommunity']);
         });

         $router->group(['prefix' => 'suspensions'], function (Router $router){
            $router->post('add', [CommunityController::class, 'addSuspension']);
            $router->delete('remove', [CommunityController::class, 'removeSuspension']);
         });

         $router->group(['prefix' => 'posts'], function (Router $router) {
            $router->post('publish', [PostController::class, 'createPost']);
            $router->post('republish', [CommunityController::class, 'republishCommunityPost']);
         });

         $router->group(['prefix' => 'membership-requests'], function (Router $router) {
            $router->post('add', [CommunityController::class, 'addMembershipRequest']);
            $router->put('cancel', [CommunityController::class, 'cancelMembershipRequest']);
            $router->put('decline', [CommunityController::class, 'declineMembershipRequest']);
            $router->put('approve', [CommunityController::class, 'approveMembershipRequest']);
            $router->get('', [CommunityController::class, 'userRequests']);
         });
      });
   });

   /**
    * Public routes
    */
   $router->group(['prefix' => 'public', 'middleware' => 'guest'], function (Router $router) {
      /**
       * Dispute types
       */
      $router->group(['prefix' => 'dispute-types'], function (Router $router) {
         $router->get('', [DisputeTypeController::class, 'disputeTypes']);
      });

      /**
       * Communities
       */
      $router->group(['prefix' => 'communities'], function (Router $router) {
         $router->get('')->name('community.share');
      });

      /**
       * Test
       */
      $router->group(['prefix' => 'tests'], function (Router $router) {
         $router->get('language-detector', [TestController::class, 'languageDetector']);
         $router->get('timezone', [TestController::class, 'timeZoneTest']);

         /**
          * test chat
          */
         $router->group(['prefix' => 'chats'], function (Router $router) {
            $router->post('chat-message', [TestController::class, 'sendChatMessageTest']);
         });
      });

      /**
       * Users
       */
      $router->group(['prefix' => 'users'], function (Router $router) {
         $router->get('/generate/username', [UserController::class, 'uniqueUsernames']);
         $router->get('/{userId}/profile')->name('users.profile-url');
         $router->get('search', [SearchHistoryController::class, 'search']);
      });

      /**
       * Countries
       */
      $router->group(['prefix' => 'countries'], function (Router $router) {
         $router->get('/raw', [CountryController::class, 'rawCountries']);
      });

      /**
       * Currencies
       */
      $router->group(['prefix' => 'currencies'], function (Router $router) {
         $router->get('', [CurrencyController::class, 'supportedCurrencies']);
      });

      /**
       * Docs
       */
      $router->group(['prefix' => 'docs'], function (Router $router) {
         $router->get('/serve', [StorageFileController::class, 'serveDocFile'])->name('serve.doc');
      });

      /**
       * Cities
       */
      $router->group(['prefix' => 'cities'], function (Router $router) {
         $router->post('get-raw', [CityController::class, 'getRawCitiesByCountry']);
      });
   });
});
