<?php

use App\Http\Controllers\Api\Auth\AblyController;
use App\Http\Controllers\Api\Auth\LoginController;
use App\Http\Controllers\Api\Auth\RegisterController;
use App\Http\Controllers\Api\Platform\OtpVerificationController;
use Illuminate\Support\Facades\Route;
use Illuminate\Routing\Router;

/*
|--------------------------------------------------------------------------
| API Auth routes
|--------------------------------------------------------------------------
|
| Spa & Mobile authentication routes
|
*/

/**
 * Otp routes
 */
Route::group(['prefix' => 'otp', 'middleware' => 'guest'], function(Router $router) {
    $router->post('/send', [OtpVerificationController::class, 'sendOtpCode']);
    $router->post('/verify', [OtpVerificationController::class, 'checkOtp']);
});

/**
 * Auth routes
 */
Route::group(['prefix' => 'auth'], function(Router $router) {
    $router->group(['middleware' => 'auth:sanctum'], function(Router $router) {
        $router->get('user', [LoginController::class, 'user']);
        // Ably real time
        $router->post('ably/create-auth-token', [AblyController::class, 'createTokenRequest']);
    });

    $router->group(['middleware' => 'guest'], function(Router $router) {
        $router->post('', [LoginController::class, 'authenticate']);
        $router->post('/register', [RegisterController::class, 'register']);
    });
});
