<?php

namespace Database\Seeders;

use App\Models\DisputeType;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class DisputeTypeSeeder extends Seeder
{
   /**
    * Run the database seeds.
    */
   public function run(): void
   {
      $types = config('seeder.dispute_types');

      foreach ($types as $type) {
         if(! DB::table('dispute_types')->where('code', $type["code"])->exists()) {
            DisputeType::factory()->create([
               "designation" => $type["designation"],
               "code" => $type["code"],
            ]);
         }
      }
   }
}
