<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('message_delivery_history', function (Blueprint $table) {
            $table->bigIncrements('id');

            $table->timestamp('delivered_at')->nullable();

            $table
                ->foreignId('message_id')
                ->constrained('realtime_messages')
                ->onUpdate('cascade')
                ->onDelete('cascade');
            $table
                ->foreignId('participant_id')
                ->constrained('realtime_participants')
                ->onUpdate('cascade')
                ->onDelete('cascade');

            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrent();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('message_delivery_history');
    }
};
