<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
   /**
    * Run the migrations.
    */
   public function up(): void
   {
      /*
      Schema::disableForeignKeyConstraints();
      Schema::dropIfExists('chats');
      Schema::dropIfExists('realtime_participants');
      Schema::dropIfExists('realtime_messages');
      Schema::dropIfExists('message_delivery_history');
      Schema::dropIfExists('message_view_history');
      Schema::dropIfExists('dispute_types');
      Schema::dropIfExists('disputes');
      Schema::dropIfExists('dispute_participants');
      Schema::dropIfExists('dispute_messages');
      Schema::enableForeignKeyConstraints();
      */

      Schema::create('chats', function (Blueprint $table) {
         $table->bigIncrements('id');

         $table->string('uuid')->unique();
         $table->string('name')->unique();

         $table->timestamp('created_at')->useCurrent();
         $table->timestamp('updated_at')->useCurrent();
         $table->softDeletes();
      });
   }

   /**
    * Reverse the migrations.
    */
   public function down(): void
   {
      Schema::dropIfExists('chats');
   }
};
