<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('account_notification_settings', function (Blueprint $table) {
            $table->bigIncrements('id');

            $table->string('enable_push_notification');
            $table->string('new_orders');
            $table->string('likes');
            $table->string('comments');
            $table->string('shares');
            $table->string('reviews');
            $table->string('direct_messages');
            $table->string('post_from_subscribed_accounts');
            $table->string('live_stream_from_subscribed_accounts');
            $table->string('disputes');
            $table->string('deposits');
            $table->string('withdrawals');
            $table->string('transfers');
            $table->string('new_subscribers');
            $table->string('post_mentions');

            $table
                ->foreignId('user_id')
                ->constrained('users')
                ->onUpdate('cascade')
                ->onDelete('cascade');

            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrent();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('account_notification_settings');
    }
};
