<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('content_restrictions', function (Blueprint $table) {
            $table->bigIncrements('id');

            $table->string('keyword')->nullable();

            $table
                ->foreignId('user_id')
                ->constrained('users')
                ->onUpdate('cascade')
                ->onDelete('cascade');
            $table
                ->foreignId('business_category_id')
                ->nullable()
                ->constrained('business_categories')
                ->onUpdate('cascade')
                ->onDelete('cascade');
            $table
                ->foreignId('business_sub_category_id')
                ->nullable()
                ->constrained('business_sub_categories')
                ->onUpdate('cascade')
                ->onDelete('cascade');
            $table
                ->foreignId('business_sub_category_child_id')
                ->nullable()
                ->constrained('business_sub_category_child')
                ->onUpdate('cascade')
                ->onDelete('cascade');

            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrent();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('content_restrictions');
    }
};
