<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('transactions', function (Blueprint $table) {
            $table->bigIncrements('id');

            $table->string('type'); //Use TransactionTypesNum
            $table->string('status'); //Use TransactionStatusEnum
            $table->float('source_amount', 12, 2);
            $table->float('source_old_balance', 12, 2)->nullable();
            $table->float('source_new_balance', 12, 2)->nullable();
            $table->float('destination_amount', 12, 2)->nullable();
            $table->float('destination_old_balance', 12, 2)->nullable();
            $table->float('destination_new_balance', 12, 2)->nullable();
            $table->float('exchange_rate', 8,4);
            $table->string('transaction_reference');
            $table->string('payment_gateway'); // Use PaymentGateWayEnum

            $table
                ->foreignId('external_account_source_id')
                ->nullable()
                ->constrained('external_accounts')
                ->onUpdate('cascade')
                ->onDelete('cascade');
            $table
                ->foreignId('external_account_destination_id')
                ->nullable()
                ->constrained('external_accounts')
                ->onUpdate('cascade')
                ->onDelete('cascade');
            $table
                ->foreignId('source_wallet_id')
                ->nullable()
                ->constrained('wallets')
                ->onUpdate('cascade')
                ->onDelete('cascade');
            $table
                ->foreignId('source_currency_id')
                ->nullable()
                ->constrained('currencies')
                ->onUpdate('cascade')
                ->onDelete('cascade');
            $table
                ->foreignId('destination_wallet_id')
                ->nullable()
                ->constrained('wallets')
                ->onUpdate('cascade')
                ->onDelete('cascade');
            $table
                ->foreignId('destination_currency_id')
                ->nullable()
                ->constrained('currencies')
                ->onUpdate('cascade')
                ->onDelete('cascade');
            $table
                ->foreignId('transaction_parent_id')
                ->nullable()
                ->constrained('transactions')
                ->onUpdate('cascade')
                ->onDelete('cascade');
            $table
                ->foreignId('escrow_id')
                ->nullable()
                ->constrained('escrows')
                ->onUpdate('cascade')
                ->onDelete('cascade');


            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrent();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('transactions');
    }
};
