<?php

use App\Enums\GenericStatusEnum;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('posts', function (Blueprint $table) {
            $table->bigIncrements('id');

            $table->longText('content');
            $table->string('turn_on_comment')->default(GenericStatusEnum::enable->value);
            $table->bigInteger('comments')->default(config("torryme.constants.default_zero_number"));
            $table->bigInteger('likes')->default(config("torryme.constants.default_zero_number"));
            $table->bigInteger('shares')->default(config("torryme.constants.default_zero_number"));
            $table->bigInteger('saves')->default(config("torryme.constants.default_zero_number"));
            $table->bigInteger('views')->default(config("torryme.constants.default_zero_number"));
            $table->timestamp('completed_at')->nullable();
            $table->string('timeline_type');

           $table
              ->foreignId('community_id')
              ->nullable()
              ->constrained('communities')
              ->onUpdate('cascade')
              ->onDelete('cascade');
            $table
                ->foreignId('product_id')
                ->nullable()
                ->constrained('products')
                ->onUpdate('cascade')
                ->onDelete('cascade');
            $table
                ->foreignId('business_id')
                ->nullable()
                ->constrained('businesses')
                ->onUpdate('cascade')
                ->onDelete('cascade');
            $table
                ->foreignId('user_id')
                ->nullable()
                ->constrained('users')
                ->onUpdate('cascade')
                ->onDelete('cascade');
            $table
                ->foreignId('reposted_post_id')
                ->nullable()
                ->constrained('posts')
                ->onUpdate('cascade')
                ->onDelete('cascade');

            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrent();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('posts');
    }
};
