<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('series_seasons', function (Blueprint $table) {
            $table->bigIncrements('id');

            $table->string('designation')->nullable();
            $table->longText('description')->nullable();
            $table->integer('occurrence');
            $table->float('downloadable_price', 12, 2); // Default price to be set to 0
            $table->float('downloadable_price_per_episode', 12, 2); // Default price to be set to 0

            $table->foreignId('series_id')
                ->constrained('series')
                ->onUpdate('cascade')
                ->onDelete('cascade');
            $table->foreignId('price_currency_id')
                ->nullable()
                ->constrained('currencies')
                ->onUpdate('cascade')
                ->onDelete('cascade');

            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrent();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('series_seasons');
    }
};
