<?php

use App\Enums\BusinessAffiliateStatusEnum;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('business_affiliates', function (Blueprint $table) {
            $table->bigIncrements('id');

            $table->timestamp('expired_at');
            $table->string('status')->default(BusinessAffiliateStatusEnum::active->value);

            $table
                ->foreignId('business_affiliate_id')
                ->constrained('businesses')
                ->onUpdate('cascade')
                ->onDelete('cascade');
            $table
                ->foreignId('business_affiliated_id')
                ->constrained('businesses')
                ->onUpdate('cascade')
                ->onDelete('cascade');
            $table
                ->foreignId('affiliate_program_id')
                ->constrained('affiliate_programs')
                ->onUpdate('cascade')
                ->onDelete('cascade');

            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrent();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('business_affiliates');
    }
};
