<?php

use App\Enums\BusinessAffiliateStatusEnum;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('affiliate_programs', function (Blueprint $table) {
            $table->bigIncrements('id');

            $table->string('designation');
            $table->longText('description')->nullable();
            $table->float('percentage', 12,2);
            $table->timestamp('started_at');
            $table->integer('active_days');
            $table->string('status')->default(BusinessAffiliateStatusEnum::active->value);

            $table
                ->foreignId('business_id')
                ->constrained('businesses')
                ->onUpdate('cascade')
                ->onDelete('cascade');


            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrent();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('affiliate_programs');
    }
};
