<?php

use App\Enums\WorkingHoursTypeEnum;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('business_working_hours', function (Blueprint $table) {
            $table->bigIncrements('id');

            $table->string('day')->nullable();
            $table->time('opening_hour')->nullable();
            $table->time('closing_hour')->nullable();
            $table->text('comment')->nullable();
            $table->string('type')->default(WorkingHoursTypeEnum::always->value);

            $table
                ->foreignId('business_id')
                ->constrained('businesses')
                ->onUpdate('cascade')
                ->onDelete('cascade');

            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrent();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('business_working_hours');
    }
};
