<?php

use App\Enums\PasswordAndWalletPinChangeStatusEnum;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('password_change_histories', function (Blueprint $table) {
            $table->bigIncrements('id');

            $table->string('old_password');
            $table->string('new_password');
            $table->string('status')->default(PasswordAndWalletPinChangeStatusEnum::active->value);

            $table
                ->foreignId('user_id')
                ->constrained('users')
                ->onUpdate('cascade')
                ->onDelete('cascade');

            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrent();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('password_change_histories');
    }
};
