<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
   /**
    * Run the migrations.
    */
   public function up(): void
   {
      Schema::create('wallets', function (Blueprint $table) {
         $table->bigIncrements('id');

         $table->float('balance', 12, 2);
         $table->string('wallet_pin')->nullable();
         $table->integer('pin_attempts_left')->default(config('torryme.constants.max_pin_attempts'));
         $table->string('wallet_number', config("torryme.constants.wallet_id_length"))->unique();
         $table->dateTime('blocked_at')->nullable();

         $table
            ->foreignId('user_id')
            ->constrained('users')
            ->onUpdate('cascade')
            ->onDelete('cascade');
         $table
            ->foreignId('currency_id')
            ->constrained('currencies')
            ->onUpdate('cascade')
            ->onDelete('cascade');

         $table->timestamp('created_at')->useCurrent();
         $table->timestamp('updated_at')->useCurrent();
         $table->softDeletes();
      });
   }

   /**
    * Reverse the migrations.
    */
   public function down(): void
   {
      Schema::dropIfExists('wallets');
   }
};
