<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('otp_verifications', function (Blueprint $table) {
            $table->bigIncrements('id');

            $table->string('otp');
            $table->string('telephone')->nullable();
            $table->string('email')->nullable();
            $table->timestamp('send_at');
            $table->timestamp('expired_at')->nullable();
            $table->timestamp('validated_at')->nullable();
            $table->integer('otp_attempts_left')->default(config('torryme.constants.max_otp_attempts'));

            $table
                ->foreignId('user_id')->nullable()
                ->constrained('users')
                ->onUpdate('cascade')
                ->onDelete('cascade');

            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrent();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('otp_verifications');
    }
};
