<?php

use App\Enums\UserTypeEnum;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('users', function (Blueprint $table) {
            $table->bigIncrements('id');

            $table->string('email')->unique()->nullable();
            $table->string('telephone')->unique()->nullable();
            $table->string('user_name')->unique();
            $table->text('bio')->nullable();
            $table->timestamp('verification_requested_at')->nullable();
            $table->timestamp('verified_at')->nullable();
            $table->timestamp('declined_at')->nullable();
            $table->timestamp('blocked_at')->nullable();
            $table->string('profile_picture')->nullable();
            $table->string('user_type')->default(UserTypeEnum::personal->value);
            $table->string('password');
            $table->string('language_code')->nullable();

            $table
                ->foreignId('user_detail_id')
                ->constrained('user_details')
                ->onUpdate('cascade')
                ->onDelete('cascade');
            $table
                ->foreignId('country_id')
                ->nullable()
                ->constrained('countries')
                ->onUpdate('cascade')
                ->onDelete('cascade');

            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrent();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('users');
    }
};
