<?php

return [

   /*
   |--------------------------------------------------------------------------
   | All torrey me app config
   |--------------------------------------------------------------------------
   |
   */

   /*
    |--------------------------------------------------------------------------
    | Constants
    |--------------------------------------------------------------------------
    */
   'constants' => [
      'default_image_extension' => '.jpg',
      'image_encoding' => 'jpg',
      'default_date_format' => 'Y-m-d',
      'default_date_time_format' => 'Y-m-d H:i:s',
      'max_file_size' => 1024 * 1024 * 5, // Mega bytes (MB)
      'otp_length' => 6,
      'max_otp_attempts' => 3,
      'wallet_pin_length' => 6,
      'max_pin_attempts' => 3,
      'wallet_number_length' => 12,
      'can_affiliate' => 1,
      'can_not_affiliate' => 0,
      'default_demo_otp' => '000000',
      'default_demo_telephone' => '+237678360696',
      'default_currency_code' => 'USD',
      'otp_validity' => 30, // In minutes
      'default_wallet_balance' => 0.0,
      'transaction_reference_length' => 16,
      'coupon_code_length' => 6,
      'default_coupon_code' => 'DEMOCOUPON',
      'same_currency_exchange_rate' => 1,
      'card_number_length' => 16,
      'card_pin_length' => 3,
      'items_per_page' => 20,
      'total_pages_for_no_transactions' => 0,
      'max_number_of_most_used_product_hash_tags' => 6,
      'default_quantity' => 1,
      'default_min_order' => 1,
      'default_max_order' => 0,
      'default_price' => 0,
      'default_zero_number' => 0,
      'default_one_number' => 1,
      'default_increment_or_decrement' => 1,
      'time_zone_key' => 'torryme-tz',
      'default_time_zone' => 'WAT',
   ],

   /*
    |--------------------------------------------------------------------------
    | Storage option
    |--------------------------------------------------------------------------
    */
   'storage_option' => 'local',

   /*
    |--------------------------------------------------------------------------
    | Api Tokens
    |--------------------------------------------------------------------------
    */
   'api_tokens' => [
      'lmt_provider' => [
         'url' => env('LMT_PROVIDER_URL', null),
         'username' => env('LMT_PROVIDER_USERNAME', null),
         'password' => env('LMT_PROVIDER_PASSWORD', null),
         'sender_id' => env('LMT_PROVIDER_SENDER_ID', null),
         'api_key' => env('LMT_PROVIDER_API_KEY', null),
      ],
      'avly_provider' => [
         'sender_id' => env('AVLY_PROVIDER_SENDER_ID', null),
         'api_key' => env('AVLY_PROVIDER_API_KEY', null),
      ],
   ],

   /*
    |--------------------------------------------------------------------------
    | All locales codes
    |--------------------------------------------------------------------------
    */
   'locales_keys' => [
      'fr' => 'fr',
      'en' => 'en',
   ],

   /*
    |--------------------------------------------------------------------------
    | Paths variables
    |--------------------------------------------------------------------------
    */
   'paths' => [
      'docs' => 'local/docs/%s',
      'thumbnails' => 'local/docs/thumbnails/%s',
   ],

   /*
    |--------------------------------------------------------------------------
    | Basics countries data
    |--------------------------------------------------------------------------
    */
   'countries' => [
      'cameroon' => array(
         'dial_code' => '+237',
         'designation' => 'Cameroon',
         'country_code' => 'CM',
      ),
      'france' => array(
         'dial_code' => '+33',
         'designation' => 'France',
         'country_code' => 'FR',
      ),
      'usa' => array(
         'dial_code' => '+1',
         'designation' => 'United States of America',
         'country_code' => 'US',
      )
   ],

   /*
    |--------------------------------------------------------------------------
    | Business category codes
    |--------------------------------------------------------------------------
    */
   'business_category_codes' => [
      'goods' => 'BC_GO',
      'service' => 'BC_SE',
      'cinema' => 'BC_CI',
      'music' => 'BC_MU',
      'library' => 'BC_LI',
      'affiliate' => 'BC_AF',
      'game' => "BC_Game",
   ],

   /*
    |--------------------------------------------------------------------------
    | Business sub category codes
    |--------------------------------------------------------------------------
    */
   'business_sub_category_codes' => [
      // Goods codes
      'machineries' => 'GC_MACH',
      'electronics' => 'GC_ELECT',
      'automobiles' => 'GC_AUTO',
      'home_appliances' => 'GC_HA',
      'fashion' => 'GC_Fash',
      'lights_and_lighting' => 'GC_L_&_L',
      'construction/real_estate' => 'GC_CONST_&_REA_E',
      'home_and_garden' => 'GC_H_G',
      'furniture' => 'GC_Furn',
      'fabric_and_textile_raw_material' => 'GC_FAB_TEXT_RAW_MAT',
      'beauty_and_personal_care' => 'GC_BEAUT_PER_CAR',
      'health_and_medical' => 'GC_HEALTH_MED',
      'printing_packaging_and_office_supply' => 'GC_PRNT_PACK_OFF_SUPP',
      'electrical_and_telecommunication_supplies' => 'GC_ELCT_TELE_SUPP',
      'hardware_tools_security_safety_and_fabrication_services' => 'GC_HRDWR_SEC_FAB_SER',
      'sports_entertainment' => 'GC_S_E',
      'mother_kids_and_toys' => 'GC_M_K_T',
      'gift_and_craft' => 'GC_GFT_CRFT',
      'luggage_bags_and_cases' => 'GC_LANG_BG_CA',
      'shoes_and_accessories' => 'GC_SH_ACC',
      'metals_and_alloys' => 'GC_MET_ALL',
      'chemicals' => 'GC_CHEM',
      'rubber_and_plastic' => 'GC_RUB_PLA',
      'agriculture_food_and_beverages' => 'GC_AGR_FD_BERV',
      'business_and_commercial_service_equipment' => 'GC_BIZ_COMM_SER_EQP',
      'energy_and_environment' => 'GC_ENER_ENV',
      'power_handling_and_material_handling' => 'GC_PWD_HAND_MAT_HAND',
      'pets_and_animals' => 'GC_PET_ANIM',

      // Service codes
      'graphics_and_design' => 'SC_G_D',
      'digital_marketing' => 'SC_D_M',
      'writing_and_translation' => 'SC_W_&_T',
      'video_and_animation' => 'SC_E_VID_&_ANIM',
      'music_and_audio' => 'SC_MIZ_&_AUD',
      'programming_and_tech' => 'SC_PROG_&_TECH',
      'photography' => 'SC_PHOTO',
      'business' => 'SC_BIZ',
      'ai_services' => 'SC_AI_SERV',

      // Cinema
      'cinema' => 'CC_CIN',

      // Music
      'music' => 'MC_MUZ',

      // Library
      'library' => 'LC_LIB',

      // Games
      'pc' => 'GC_PC',
      'ps4' => 'GC_PS4',
      'ps5' => 'GC_PS5',
      'xbox' => 'GC_XB',
   ],

   /*
  |--------------------------------------------------------------------------
  | Business sub category child codes
  |--------------------------------------------------------------------------
  */
   'business_sub_category_child_codes' => [
      'hard_copy' => 'H_C',
      'ebook' => 'E_B',
      'audio_book' => 'A_B',
      'audio_music' => 'M_AUDIO',
      'video_music' => 'M_VIDEO',
      'movie' => 'C_MOVIE',
      'series' => 'C_SERIES',
   ],

   /*
   |--------------------------------------------------------------------------
   | Payment Gateways
   |--------------------------------------------------------------------------
   */
   'payment_gateways' => [
      'momo' => 'MoMo',
      'orange_money' => 'Orange Money',
      'visa' => 'VISA',
      'master_card' => 'MasterCard',
      'eu_money' => 'EU Money',
      'paypal' => 'PayPal',
   ],

   /*
   |--------------------------------------------------------------------------
   | External account direction
   |--------------------------------------------------------------------------
   */
   'externL_account_direction' => [
      'in' => 'In',
      'out' => 'Out',
   ],

   /*
   |--------------------------------------------------------------------------
   | Document types
   |--------------------------------------------------------------------------
   */
   'document_types' => [
      'cni' => 'CNI',
      'driver_licence' => 'Driver licence',
      'passport' => 'Passport',
   ],

   /*
   |--------------------------------------------------------------------------
   | Document array
   |--------------------------------------------------------------------------
   */
   'document_array' => [
      'cni' => [
         'front' => 'cni_front',
         'back' => 'cni_back',
      ],
      'driver_licence' => [
         'front' => 'driver_licence_front',
         'back' => 'driver_licence_back',
      ],
      'passport' => [
         'front' => 'passport',
      ],
   ],

   /*
   |--------------------------------------------------------------------------
   | Document array
   |--------------------------------------------------------------------------
   */
   'currency_code' => [
         'xaf' => 'XAF',
         'euro'=> 'EUR',
         'usd' => 'USD',
         'cad' => 'CAD',
         'chf' => 'CHF',
         'gbp' => 'GBP',
         'zar' => 'ZAR',
         'tnd' => 'TND',
   ],

   /*
|--------------------------------------------------------------------------
| Community subscriber action
|--------------------------------------------------------------------------
*/
   'community_subscriber_action' => [
      'mark_as_admin' => 'Mark as admin',
      'mark_as_member' => 'Mark as member',
   ],

   /*
|--------------------------------------------------------------------------
| Community suspension duration
|--------------------------------------------------------------------------
*/
   'community_suspension_duration' => [
      '24_hours' => 24,
      '7_days' => 7,
      '14_days' => 14,
      '30_days' => 30,
      '90_days' => 90,
      '12_months' => 12,
   ],

];
