<?php

use App\Enums\AttributeTypeEnum;

return [
   /*
|--------------------------------------------------------------------------
| Basics dispute types
|--------------------------------------------------------------------------
*/
   'dispute_types' => [
      'late_delivery' => array(
         'code' => 'D_LD',
         'designation' => 'messages.dispute_types.late_delivery',
      ),
      'poor_quality_goods' => array(
         'code' => 'D_PQG',
         'designation' => 'messages.dispute_types.poor_quality_goods',
      ),
      'failure_to_deliver' => array(
         'code' => 'D_FTD',
         'designation' => 'messages.dispute_types.failure_to_deliver',
      )
   ],

    /*
      |--------------------------------------------------------------------------
      | Basics currencies data
      |--------------------------------------------------------------------------
      */
   'currencies' => [
      'xaf' => array(
         'code' => "torryme.currency_code.xaf",
         'designation' => 'messages.currency_designation.franc_cfa',
      ),
      'euro' => array(
         'code' => "torryme.currency_code.euro",
         'designation' => 'messages.currency_designation.euro',
      ),
      'usd' => array(
         'code' => "torryme.currency_code.usd",
         'designation' => 'messages.currency_designation.american_dollars',
      ),
      'cad' => array(
         'code' => "torryme.currency_code.cad",
         'designation' => 'messages.currency_designation.canadian_dollar',
      ),
      'chf' => array(
         'code' => "torryme.currency_code.chf",
         'designation' => 'messages.currency_designation.swiss_franc',
      ),
      'gbp' => array(
         'code' => "torryme.currency_code.gbp",
         'designation' => 'messages.currency_designation.pound_sterling',
      ),
      'zar' => array(
         'code' => "torryme.currency_code.zar",
         'designation' => 'messages.currency_designation.rand',
      ),
      'tnd' => array(
         'code' => "torryme.currency_code.tnd",
         'designation' => 'messages.currency_designation.tunisian_dinar',
      )
   ],

    /*
      |--------------------------------------------------------------------------
      | Business category data
      |--------------------------------------------------------------------------
      */
    'business_categories' => [
        'good' => array(
            'designation' => 'messages.business_categories.goods.designation',
            'code' => "torryme.business_category_codes.goods",
            'description' => 'messages.business_categories.goods.description',
            'sub_categories' => array(
                array(
                    'designation' => 'messages.business_sub_categories.machineries.designation',
                    'code' => "torryme.business_sub_category_codes.machineries",
                    'description' => 'messages.business_sub_categories.machineries.description',
                    'child_sub_categories' => array(
                        array(
                            'designation' => 'messages.business_child_sub_categories.agricultural_machinery_and_equipment.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(
                                array('designation' => 'messages.business_grand_child_sub_categories.forestry_machinery.designation'),
                            ),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.metal_and_metallurgy_machinery.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(
                                array('designation' => 'messages.business_grand_child_sub_categories.agricultural_machinery_parts.designation'),
                            ),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.electronic_products_machinery.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(
                                array('designation' => 'messages.business_grand_child_sub_categories.silos.designation'),
                            ),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.woodworking_machinery.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(
                                array('designation' => 'messages.business_grand_child_sub_categories.agricultural.designation'),
                            ),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.welding_equipment.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(
                                array('designation' => 'messages.business_grand_child_sub_categories.sprayers.designation'),
                            ),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.industrial_compressors_and_parts.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(
                                array('designation' => 'messages.business_grand_child_sub_categories.towable_backhoes.designation'),
                            ),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.home_product_manufacturing_machinery.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(
                                array('designation' => 'messages.business_grand_child_sub_categories.biomass_briquette_machines.designation'),
                            ),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.production_line.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(
                                array('designation' => 'messages.business_grand_child_sub_categories.farm_trailers.designation'),
                            ),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.cleaning_equipment.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(
                                array('designation' => 'messages.business_grand_child_sub_categories.farm_irrigation_systems.designation'),
                            ),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.printing_machine.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(
                                array('designation' => 'messages.business_grand_child_sub_categories.fertilizer_spreaders.designation'),
                            ),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.paper_production_machinery.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.plastic_and_rubber_processing_machinery.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.industry_laser_equipment.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.packaging_machines.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.chemical_and_pharmaceutical_machinery.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.apparel_and_textile_machinery.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.electronics_production_machinery.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.other_machinery_and_industrial_equipment.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.used_industrial_machinery.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.environmental_machinery.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.machinery_accessories.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.tobacco_and_cigarette_machinery.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.machinery_service.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.food_and_beverage_machinery.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.machine_tool_equipment.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.refrigeration_and_heat_exchange_equipment.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.electrical_equipment_manufacturing_machinery.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.engineering_and_construction_machinery.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.energy_and_mineral_equipment.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.building_material_machinery.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.used_machinery.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                    ),
                ),
                array(
                    'designation' => 'messages.business_sub_categories.automobiles.designation',
                    'code' => "torryme.business_sub_category_codes.automobiles",
                    'description' => 'messages.business_sub_categories.automobiles.description',
                    'child_sub_categories' => array(
                        array(
                            'designation' => 'messages.business_child_sub_categories.containers.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.truck.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.golf_carts.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.bus.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.special_transportation.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.new_energy_vehicles.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.emergency_vehicles.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.train_carriage.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.locomotives.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.motorcycles_and_Scooters.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.tvs.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.automotive.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.trailers.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.tricycles.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.automotive_parts_and_accessories.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.train_parts_and_accessories.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.universal_parts.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.railway_parts_and_accessories.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.new_energy_vehicle_parts_and_accessories.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.motorcycle_parts_and_accessories.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.go_Kart_and_art_racer_parts_and_accessories.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.recovery_and_Off_road_and_accessories.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.bus_parts_and_accessories.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.wheels_tires_and_accessories.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.marine_parts_and_accessories.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.tv_parts.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.heavy_duty_vehicle_parts_and_accessories.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.container_parts_and_accessories.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.truck_parts_and_accessories.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.aviation_parts_and_accessories.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.trailer_parts_and_accessories.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                    ),
                ),
                array(
                    'designation' => 'messages.business_sub_categories.electronics.designation',
                    'code' => "torryme.business_sub_category_codes.electronics",
                    'description' => 'messages.business_sub_categories.electronics.description',
                    'child_sub_categories' => array(
                        array(
                            'designation' => 'messages.business_child_sub_categories.computer_hardware_and_software.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.cables_and_commonly_used_accessories.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.projectors_and_presentation_equipment.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.used_electronics.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.other_consumer_electronics.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.chargers_batteries_and_power_supplies.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.mobile_phone_and_accessories.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.video_games_and_accessories.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.portable_audio_video_and_accessories.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.camera_photo_and_accessories.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.television_home_audio_video_and_accessories.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.electronic_publications.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.vr_ar_mr_hardware_and_software.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.earphone_and_headphone_and_accessories.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.speakers_and_accessories.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.smart_electronics.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.tv_receivers_and_accessories.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.mobile_phone_abd_computer_repair_parts.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                    ),
                ),
                array(
                    'designation' => 'messages.business_sub_categories.home_appliances.designation',
                    'code' => "torryme.business_sub_category_codes.home_appliances",
                    'description' => 'messages.business_sub_categories.home_appliances.description',
                    'child_sub_categories' => array(
                        array(
                            'designation' => 'messages.business_child_sub_categories.smart_home_appliances.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.other_home_appliances.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.home_appliance_stock.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.cleaning_appliances.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.major_kitchen_appliances.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.second_hand_appliances.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.refrigerators_and_freezers.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.air_conditioning_appliances.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.home_heaters.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.home_appliance_parts.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.laundry_appliances.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.small_kitchen_appliances.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.water_treatment_appliances.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.water_heaters.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.personal_and_care_and_beauty_appliances.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                    ),
                ),
                array(
                    'designation' => 'messages.business_sub_categories.fashion.designation',
                    'code' => "torryme.business_sub_category_codes.fashion",
                    'description' => 'messages.business_sub_categories.fashion.description',
                    'child_sub_categories' => array(
                        array(
                            'designation' => 'messages.business_child_sub_categories.wedding_apparel_and_accessories.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.socks_and_hosiery.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.other_apparel.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.sportswear.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.ethnic_clothing.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.garment_and_processing_and_accessories.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.womens_clothing.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.men_clothing.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.novelty_and_special_use.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.belts_and_accessories.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.gloves_and_mittens.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.scarves_and_shawls.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.ties_and_accessories.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.hats_and_caps.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.clothes_accessories.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.hair_accessories.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.scarf_hat_and_glove_sets.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.sleeves_and_knee_sleeves.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.other_fashion_accessories.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.ear_muffs_and_eye_masks.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.ethnic_accessories.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.jewelry.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.watches.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.eye_wear.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.eye_wear_accessories.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.watch_accessories_parts.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.jewelry_accessories.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                    ),
                ),
                array(
                    'designation' => 'messages.business_sub_categories.lights_and_lighting.designation',
                    'code' => "torryme.business_sub_category_codes.lights_and_lighting",
                    'description' => 'messages.business_sub_categories.lights_and_lighting.description',
                    'child_sub_categories' => array(
                        array(
                            'designation' => 'messages.business_child_sub_categories.smart_lighting.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.lighting_accessories.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.lighting_bulbs_and_tubes.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.indoor_lighting.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.outdoor_lighting.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.professional_lighting.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.landscape_lighting.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.healthcare_lighting.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.commercial_and_industrial_lighting.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.holiday_lighting.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.other_lights_and_lighting_products.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.solar_lighting.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                    ),
                ),
                array(
                    'designation' => 'messages.business_sub_categories.construction/real_estate.designation',
                    'code' => "torryme.business_sub_category_codes.construction/real_estate",
                    'description' => 'messages.business_sub_categories.construction/real_estate.description',
                    'child_sub_categories' => array(
                        array(
                            'designation' => 'messages.business_child_sub_categories.prefabricated_buildings.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.counter_tops_and_vanity_tops_and_table_ops.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.building_and_industrial_and_glass.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.mosaics.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.metal_building_materials.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.multifunctional_materials.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.ladders_and_scaffolding.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.mouldings.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.corner_guards.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.decorative_films.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.form_work.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.other_construction_and_real_and_estate.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.soundproofing_materials.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.waterproofing_materials.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.building_boards.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.plastic_building_materials.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.fireproofing_materials.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.earthwork_products.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.heat_insulation_materials.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.curtain_walls_and_accessories.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.masonry_materials.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.stone.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.elevators_and_escalators.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.plastic_tubes.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.ceilings.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.door_window_and_accessories.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.floor_heating_systems_parts.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.stairs_and_stair_parts.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.fireplaces_and_stoves.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.wallpapers_wall_panels.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.hvac_system_and_parts.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.tiles_and_accessories.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.balustrades_handrails.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.flooring_and_accessories.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.bathroom_kitchen.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.outdoor_facilities.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                    ),
                ),
                array(
                    'designation' => 'messages.business_sub_categories.home_and_garden.designation',
                    'code' => "torryme.business_sub_category_codes.home_and_garden",
                    'description' => 'messages.business_sub_categories.home_and_garden.description',
                    'child_sub_categories' => array(
                        array(
                            'designation' => 'messages.business_child_sub_categories.garden_supplies.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.household_cleaning_tools_and_accessories.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.lighters_and_smoking_accessories.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.home_storage_and_organization.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.household_scales.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.home_decor.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.home_textiles.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.kitchen_and_tabletop.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.smart_home_improvement.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.bathroom_products.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.festive_and_party_supplies.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.rain_gear.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.household_sundries.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                    ),
                ),
                array(
                    'designation' => 'messages.business_sub_categories.furniture.designation',
                    'code' => "torryme.business_sub_category_codes.furniture",
                    'description' => 'messages.business_sub_categories.furniture.description',
                    'child_sub_categories' => array(
                        array(
                            'designation' => 'messages.business_child_sub_categories.furniture_accessories.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.home_furniture.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.commercial_furniture.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.outdoor_furniture.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.furniture_hardware.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.other_furniture.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.furniture_parts.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.kids_furniture.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                    ),
                ),
                array(
                    'designation' => 'messages.business_sub_categories.fabric_and_textile_raw_material.designation',
                    'code' => "torryme.business_sub_category_codes.fabric_and_textile_raw_material",
                    'description' => 'messages.business_sub_categories.fabric_and_textile_raw_material.description',
                    'child_sub_categories' => array(
                        array(
                            'designation' => 'messages.business_child_sub_categories.leather_products.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.yarn.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.fiber.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.thread.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.textile_processing.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.textile_accessories.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.other_textiles_and_leather_products.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.fur.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.down_and_feather.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.fabric.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                    ),
                ),
                array(
                    'designation' => 'messages.business_sub_categories.beauty_and_personal_care.designation',
                    'code' => "torryme.business_sub_category_codes.beauty_and_personal_care",
                    'description' => 'messages.business_sub_categories.beauty_and_personal_care.description',
                    'child_sub_categories' => array(
                        array(
                            'designation' => 'messages.business_child_sub_categories.skin_care_and_tools.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.mail_supplies.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.body_art.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.makeup_and_tools.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.beauty_equipment.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.perfume_and_fragrance.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.other_beauty_and_personal_care_products.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.mini_size_and_gift_sets.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.hair_extensions_and_wigs.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.used_beauty_care.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.eyelash_beauty_and_tools.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.aesthetic_medicine.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.kitchen_and_bathroom_cleaning.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.hygiene_products.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.salon_accessories.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.oral_Care.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.bath_supplies.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.mens_grooming.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.hair_care_and_styling.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.laundry_cleaning_supplies.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.feminine_care.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.pest_control_products.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.other_personal_care_products.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.travel_size_and_gift_sets.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.room_deodorizers.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.floor_cleaning.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.hands_and_feet_care.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.body_care.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.special_household_cleaning.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                    ),
                ),
                array(
                    'designation' => 'messages.business_sub_categories.health_and_medical.designation',
                    'code' => "torryme.business_sub_category_codes.health_and_medical",
                    'description' => 'messages.business_sub_categories.health_and_medical.description',
                    'child_sub_categories' => array(
                        array(
                            'designation' => 'messages.business_child_sub_categories.extracts.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.sex_products.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.medical_consumables.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.chinese_medicine.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.professional_medical_devices.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.health_care_products.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.animal_and_veterinary.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.household_medical_devices.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                    ),
                ),
                array(
                    'designation' => 'messages.business_sub_categories.printing_packaging_and_office_supply.designation',
                    'code' => "torryme.business_sub_category_codes.printing_packaging_and_office_supply",
                    'description' => 'messages.business_sub_categories.printing_packaging_and_office_supply.description',
                    'child_sub_categories' => array(
                        array(
                            'designation' => 'messages.business_child_sub_categories.packaging_raw_materials.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.plastic_packaging.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.paper_packaging.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.packaging_and_printing_services.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.logistics_packaging.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.glass_packaging.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.pharmaceutical_packaging.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.metal_packaging.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.other_packaging_and_printing_products.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.textile_packaging.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.packaging_auxiliary_materials.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.wooden_and_bamboo_packaging.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.printing_materials.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.calculators.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.pencil_sharpeners.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.pens.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.letter_pad_paper.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.office_paper.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.printer_supplies.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.book_covers.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.other_office_and_school_supplies.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.stationery_set.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.stamps.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.drafting_supplies.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.stencils.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.electronic_dictionary.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.books.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.map.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.magazines.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.calendars.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.writing_accessories.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.markers_and_highlighters.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.easels.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.yellow_pages.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.commercial_office_supplies.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.file_folder_accessories.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.notebooks_and_writing_pads.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.pencil_cases_and_bags.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.correction_supplies.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.office_adhesives_and_tapes.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.education_supplies.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.office_binding_supplies.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.board_erasers.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.office_cutting_supplies.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.paper_envelopes.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.pencils.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.desk_organizers.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.badge_holder_accessories.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.art_supplies.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.filing_products.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.clipboards.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.boards.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.lab_supplies.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.testing_instruments.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.testing_equipment.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.measuring_and_gauging_tools.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                    ),
                ),
                array(
                    'designation' => 'messages.business_sub_categories.electrical_and_telecommunication_supplies.designation',
                    'code' => "torryme.business_sub_category_codes.electrical_and_telecommunication_supplies",
                    'description' => 'messages.business_sub_categories.electrical_and_telecommunication_supplies.description',
                    'child_sub_categories' => array(
                        array(
                            'designation' => 'messages.business_child_sub_categories.professional_audio_video_and_lighting.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.electrical_supplies.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.wiring_accessories.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.connectors_and_terminals.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.industrial_controls.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.electrical_instruments.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.low_voltage_products.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.wires_cables_and_cable_assemblies.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.generators.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.switches.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.power_supplies.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.medium_and_high_voltage_products.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.pcb_and_pcba.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.circuit_protection.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.connectors_terminals_and_accessories.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.telecommunications.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.development_boards_electronic_modules_and_kits.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.electronic_accessories_and_supplies.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.passive_components.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.isolators.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.audio_components_and_products.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.sensors.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.displays_signage_and_optoelectronic.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.rf_microwave_and_rfid.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.discrete_semiconductors.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.wireless_and_iot_Module_and_products.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.relays.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.integrated_circuits.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                    ),
                ),
                array(
                    'designation' => 'messages.business_sub_categories.hardware_tools_security_safety_and_fabrication_services.designation',
                    'code' => "torryme.business_sub_category_codes.hardware_tools_security_safety_and_fabrication_services",
                    'description' => 'messages.business_sub_categories.hardware_tools_security_safety_and_fabrication_services.description',
                    'child_sub_categories' => array(
                        array(
                            'designation' => 'messages.business_child_sub_categories.pumps_and_parts.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.tool_storage.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.fasteners.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.welding_and_soldering_supplies.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.pneumatic_tools.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.hardware.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.valves.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.abrasives.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.hydraulic_tools.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.machining.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.tool_parts.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.power_tools.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.drill_bits.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.hand_tools.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.other_tools.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.tool_sets.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.pipe_fittings.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.i_o_t_solutions_and_software.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.alarms.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.surveillance_products.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.safes.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.other_security_and_protection_products.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.self_defense_supplies.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.access_control_systems_and_products.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.locks_and_keys.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.tactical_and_personal_defense_equipment.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.water_safety_products.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.personal_protective_equipment.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.firefighting_supplies.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.roadway_safety.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.moulds.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.machining_services.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.other_fabrication_services.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.casting_services.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.forging_services.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                    ),
                ),
                array(
                    'designation' => 'messages.business_sub_categories.sports_entertainment.designation',
                    'code' => "torryme.business_sub_category_codes.sports_entertainment",
                    'description' => 'messages.business_sub_categories.sports_entertainment.description',
                    'child_sub_categories' => array(
                        array(
                            'designation' => 'messages.business_child_sub_categories.field_events.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.scooters.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.souvenirs.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.Collectibles_costumes_and_toys.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.rvs_and_campers.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.boats_and_ships.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.exercise_rehabilitation.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.artificial_grass_and_sports_flooring_and_sports_court_qui.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.sports_fitness_technology.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.other_sports_and_entertainment_products.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.winter_sports.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.water_sports.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.team_sports.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.sports_safety.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.fishing.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.other_outdoor_sports.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.camping_and_hiking.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.musical_instruments.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.indoor_sports_and_entertainment.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.amusement_park_products.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.fitness_and_body_building.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.golf.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.sports_shoes.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.sport_bags.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.cycling.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.yoga_pilates.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                    ),
                ),
                array(
                    'designation' => 'messages.business_sub_categories.mother_kids_and_toys.designation',
                    'code' => "torryme.business_sub_category_codes.mother_kids_and_toys",
                    'description' => 'messages.business_sub_categories.mother_kids_and_toys.description',
                    'child_sub_categories' => array(
                        array(
                            'designation' => 'messages.business_child_sub_categories.baby_food.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.kids_accessories.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.promotional_toys.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.baby_supplies_and_products.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.baby_care.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.blocks_and_model_building_toys.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.toy_guns.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.baby_Clothing.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.pools_and_water_fun.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.puzzle_and_games.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.toddler_clothing.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.baby_furniture.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.electronic_toys.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.maternity_clothes.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.kids_shoes.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.balloons.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.stuffed_animals_and_plush_toys.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.toy_vehicle.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.outdoor_toys_and_structures.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.educational_toys.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.dress_up_and_pretend_play.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.classic_toys.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.baby_and_toddler_toys.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.pregnancy_and_maternity.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.baby_appliances.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.dolls_and_accessories.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.arts_crafts_and_diy_oys.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.remote_control_toys.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.novelty_and_gag_toys.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.action_and_toy_figures.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.kids_luggage_and_bags.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.hobbies_and_models.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.children_clothing.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.Kid_textile_and_bedding.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                    ),
                ),
                array(
                    'designation' => 'messages.business_sub_categories.gift_and_craft.designation',
                    'code' => "torryme.business_sub_category_codes.gift_and_craft",
                    'description' => 'messages.business_sub_categories.gift_and_craft.description',
                    'child_sub_categories' => array(
                        array(
                            'designation' => 'messages.business_child_sub_categories.flags_banners_and_display_accessories.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.lanyard.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.stickers.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.other_gifts.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.promotional_and_business_gifts.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.crafts.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.key_chains.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                    ),
                ),
                array(
                    'designation' => 'messages.business_sub_categories.luggage_bags_and_cases.designation',
                    'code' => "torryme.business_sub_category_codes.luggage_bags_and_cases",
                    'description' => 'messages.business_sub_categories.luggage_bags_and_cases.description',
                    'child_sub_categories' => array(
                        array(
                            'designation' => 'messages.business_child_sub_categories.mens_bags.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.pets_bags.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.business_bags_and_cases.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.wallets_and_holders.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.special_purpose_bags_and_cases.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.luggage_carts.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.waist_bags.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.luggage_and_travel_bags.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.Lifestyle_bags.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.bag_luggage_parts_accessories.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.backpacks.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.sports_bags_cases.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.handbags.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.evening_bags.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.messenger_bags.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.women_bags.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.used_ags.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.outdoor_use_bags_cases.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.other_luggage_bags_and_cases.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                    ),
                ),
                array(
                    'designation' => 'messages.business_sub_categories.shoes_and_accessories.designation',
                    'code' => "torryme.business_sub_category_codes.shoes_and_accessories",
                    'description' => 'messages.business_sub_categories.shoes_and_accessories.description',
                    'child_sub_categories' => array(
                        array(
                            'designation' => 'messages.business_child_sub_categories.shoe_care_and_services.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.mens_shoes.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.women_shoes.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.outdoor_shoes.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.functional_shoes.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.shoe_parts_and_accessories.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.shoes_stock.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.other_shoes.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                    ),
                ),
                array(
                    'designation' => 'messages.business_sub_categories.metals_and_alloys.designation',
                    'code' => "torryme.business_sub_category_codes.metals_and_alloys",
                    'description' => 'messages.business_sub_categories.metals_and_alloys.description',
                    'child_sub_categories' => array(
                        array(
                            'designation' => 'messages.business_child_sub_categories.wire_mesh.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.stainless_steel.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.alloy_steel.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.non_ferrous_metal.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.metals_and_metal_products.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.carbon_steel.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.iron_and_iron_products.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                    ),
                ),
                array(
                    'designation' => 'messages.business_sub_categories.chemicals.designation',
                    'code' => "torryme.business_sub_category_codes.chemicals",
                    'description' => 'messages.business_sub_categories.chemicals.description',
                    'child_sub_categories' => array(
                        array(
                            'designation' => 'messages.business_child_sub_categories.energy_chemicals.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.flavor_and_fragrance.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.chemical_reagents.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.non_explosive_demolition_agents.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.other_chemicals.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.custom_chemical_services.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.biological_chemical_products.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.painting_and_coating.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.surface_treatment_chemicals.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.catalysts_and_chemical_auxiliary_agents.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.admixture_and_Additives.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.pigments_and_dyestuff.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.basic_organic_chemicals.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.Agrochemicals.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.inorganic_chemicals.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.Coating_and_paint.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.chemical_waste.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.daily_chemicals.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.adhesives_and_sealants.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.polymer.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.designation.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.organic_intermediate.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                    ),
                ),
                array(
                    'designation' => 'messages.business_sub_categories.rubber_and_plastic.designation',
                    'code' => "torryme.business_sub_category_codes.rubber_and_plastic",
                    'description' => 'messages.business_sub_categories.rubber_and_plastic.description',
                    'child_sub_categories' => array(
                        array(
                            'designation' => 'messages.business_child_sub_categories.plastic_raw_materials.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.rubber_raw_materials.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.plastic_products.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.plastic_projects.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.plastic_stocks.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.recycled_plastic.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.recycled_rubber.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.rubber_products.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.rubber_projects.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.rubber_stock.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                    ),
                ),
                array(
                    'designation' => 'messages.business_sub_categories.agriculture_food_and_beverages.designation',
                    'code' => "torryme.business_sub_category_codes.agriculture_food_and_beverages",
                    'description' => 'messages.business_sub_categories.agriculture_food_and_beverages.description',
                    'child_sub_categories' => array(
                        array(
                            'designation' => 'messages.business_child_sub_categories.fresh_fruit.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.beans.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.mushrooms_and_truffles.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.other_agriculture_products.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.agricultural_waste.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.timber_raw_materials.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.fresh_vegetables.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.animal_products.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.animal_feed.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.hemp.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.ornamental_plants.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.plant_seeds_and_bulbs.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.agricultural_equipment.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.frozen_products.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.beverages.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.nuts_and_kernels.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.seafood.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.plant_and_animal_oil.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.egg_products.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.dairy_products.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.seasonings_and_condiments.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.canned_food.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.instant_food.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.baked_goods.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.other_food_and_beverage.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.meat_and_poultry.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.confectionery.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.grain_products.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.snacks.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.honey_and_honey_products.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.frog_and_escargot.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.bean_products.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.fruit_and_vegetable_products.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.food_ingredients.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                    ),
                ),
                array(
                    'designation' => 'messages.business_sub_categories.business_and_commercial_service_equipment.designation',
                    'code' => "torryme.business_sub_category_codes.business_and_commercial_service_equipment",
                    'description' => 'messages.business_sub_categories.business_and_commercial_service_equipment.description',
                    'child_sub_categories' => array(
                        array(
                            'designation' => 'messages.business_child_sub_categories.financial_equipment.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.party_supplies.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.restaurant_and_hotel_supplies.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.funeral_supplies.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.advertising_equipment.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.commercial_robots.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.trade_show_equipment.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.warehousing_and_supermarket_supplies.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.commercial_laundry_equipment.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.vending_machines.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.other_service_equipment.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.digital_signage.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                    ),
                ),
                array(
                    'designation' => 'messages.business_sub_categories.energy_and_environment.designation',
                    'code' => "torryme.business_sub_category_codes.energy_and_environment",
                    'description' => 'messages.business_sub_categories.energy_and_environment.description',
                    'child_sub_categories' => array(
                        array(
                            'designation' => 'messages.business_child_sub_categories.batteries.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.solar_energy_products.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.energy_storage_system.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.other_renewable_energy.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.wind_power_products.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.solar_applications.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.hydro_generator.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.solar_thermal_energy.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.hydrogen_energy.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.recycling.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.sewer_products.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.other_environmental_products.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.other_excess_inventory.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                    ),
                ),
                array(
                    'designation' => 'messages.business_sub_categories.power_handling_and_material_handling.designation',
                    'code' => "torryme.business_sub_category_codes.power_handling_and_material_handling",
                    'description' => 'messages.business_sub_categories.power_handling_and_material_handling.description',
                    'child_sub_categories' => array(
                        array(
                        'designation' => 'messages.business_child_sub_categories.bearings.designation',
                          'code' => null,
                        'grand_child_sub_categories' => array(),
                    ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.power_transmission_parts.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.hydraulic_parts.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.bearing_accessories.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.industrial_brakes.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.gearboxes.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.speed_reducers.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.lifting_pulling_and_positioning.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.warehousing.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.transporting.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                    ),
                ),
                array(
                    'designation' => 'messages.business_sub_categories.pets_and_animals.designation',
                    'code' => "torryme.business_sub_category_codes.pets_and_animals",
                    'description' => 'messages.business_sub_categories.pets_and_animals.description',
                    'child_sub_categories' => array(
                        array(
                            'designation' => 'messages.business_child_sub_categories.birds.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.fish.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.frogs_and_amphibians.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.invertebrates.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.kittens_and_cats.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.livestock.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.horses.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.pet_food_and_accessories.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.puppies_and_dogs.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.rabbits_and_bunnies.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.reptiles.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.small_furries.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                    ),
                ),
            ),
            'base_attributes' => array(
                'Color' => array(
                    'designation' => 'messages.base_attributes.color',
                    'type' => AttributeTypeEnum::color->value,
                    'business_id' => null,
                    'attribute_si_units' => array(),
                ),
                'Dimension' => array(
                    'designation' => 'messages.base_attributes.dimension',
                    'type' => AttributeTypeEnum::dimension->value,
                    'business_id' => null,
                    'attribute_si_units' => array(
                        array(
                            'si_unit' => "km",
                            'si_unit_designation' => "kilometre",
                        ),
                        array(
                            'si_unit' => "m",
                            'si_unit_designation' => "Metre",
                        ),
                        array(
                            'si_unit' => "cm",
                            'si_unit_designation' => "Centimetre",
                        ),
                        array(
                            'si_unit' => "mm",
                            'si_unit_designation' => "Millimetre",
                        ),
                        array(
                            'si_unit' => "μm",
                            'si_unit_designation' => "Micrometre",
                        ),
                        array(
                            'si_unit' => "nm",
                            'si_unit_designation' => "Nanometre",
                        ),
                    ),
                ),
                'Size' => array(
                    'designation' => 'messages.base_attributes.size',
                    'type' => null,
                    'business_id' => null,
                    'attribute_si_units' => array(
                        array(
                            'si_unit' => "sq km",
                            'si_unit_designation' => "Square kilometre",
                        ),
                        array(
                            'si_unit' => "ha",
                            'si_unit_designation' => "Hectare",
                        ),
                        array(
                            'si_unit' => "sq cm",
                            'si_unit_designation' => "Square centimetre",
                        ),
                    ),
                ),
                'Capacity' => array(
                    'designation' => 'messages.base_attributes.capacity',
                    'type' => null,
                    'business_id' => null,
                    'attribute_si_units' => array(
                        array(
                            'si_unit' => "kl",
                            'si_unit_designation' => "Kilolitre",
                        ),
                        array(
                            'si_unit' => "	l",
                            'si_unit_designation' => "Litre	",
                        ),
                        array(
                            'si_unit' => "cl",
                            'si_unit_designation' => "Centilitre",
                        ),
                        array(
                            'si_unit' => "ml",
                            'si_unit_designation' => "Millilitre",
                        ),
                        array(
                            'si_unit' => "μl",
                            'si_unit_designation' => "Microlitre",
                        ),
                    ),
                ),
                'Mass and weight' => array(
                    'designation' => 'messages.base_attributes.mass_and_weight',
                    'type' => null,
                    'business_id' => null,
                    'attribute_si_units' => array(
                        array(
                            'si_unit' => "t",
                            'si_unit_designation' => "Metric ton",
                        ),
                        array(
                            'si_unit' => "kg",
                            'si_unit_designation' => "kilogram",
                        ),
                        array(
                            'si_unit' => "g",
                            'si_unit_designation' => "Gram",
                        ),
                        array(
                            'si_unit' => "cg",
                            'si_unit_designation' => "centigram",
                        ),
                        array(
                            'si_unit' => "mg",
                            'si_unit_designation' => "milligram",
                        ),
                        array(
                            'si_unit' => "μg",
                            'si_unit_designation' => "microgram",
                        ),
                    ),
                ),
            ),
        ),
        'services' => array(
            'designation' => 'messages.business_categories.service.designation',
            'code' => "torryme.business_category_codes.service",
            'description' => 'messages.business_categories.service.description',
            'sub_categories' => array(
                array(
                    'designation' => 'messages.business_sub_categories.graphics_and_design.designation',
                    'code' => "torryme.business_sub_category_codes.graphics_and_design",
                    'description' => 'messages.business_sub_categories.graphics_and_design.description',
                    'child_sub_categories' => array(
                        array(
                            'designation' => 'messages.business_child_sub_categories.logo_and_brand_identity.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(
                                array('designation' => 'messages.business_grand_child_sub_categories.logo_design.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.brand_style_guides.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.business_cards_and_stationery.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.fonts_and_typography.designation'),
                            ),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.web_and_app_design.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(
                                array('designation' => 'messages.business_grand_child_sub_categories.website_design.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.app_design.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.ux_design.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.landing_page_design.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.icon_design.designation'),
                            ),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.visual_and_design.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(
                                array('designation' => 'messages.business_grand_child_sub_categories.image_editing.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.presentation_design.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.background_removal.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.infographic_design.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.vector_tracing.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.resume_design.designation'),
                            ),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.architecture_and_building_design.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(
                                array('designation' => 'messages.business_grand_child_sub_categories.architecture_and_interior_design.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.landscape_design.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.building_engineering.designation'),
                            ),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.fashion_and_merchandise.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(
                                array('designation' => 'messages.business_grand_child_sub_categories.t_shirts_and_merchandise.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.fashion_design.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.jewelry_design.designation'),
                            ),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.art_and_illustration.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(
                                array('designation' => 'messages.business_grand_child_sub_categories.illustration.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.ai_artists.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.children_book_illustration.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.portraits_and_caricatures.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.cartoons_and_comics.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.pattern_design.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.tattoo_design.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.Storyboards.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.nft_rt.designation'),
                            ),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.product_and_gaming.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(
                                array('designation' => 'messages.business_grand_child_sub_categories.industrial_and_product_design.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.character_modeling.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.game_art.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.graphic_for_streamers.designation'),
                            ),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.marketing_and_design.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(
                                array('designation' => 'messages.business_grand_child_sub_categories.social_media_design.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.social_posts_and_banners.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.email_design.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.web_banners.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.signage_design.designation'),
                            ),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.3d_design.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(
                                array('designation' => 'messages.business_grand_child_sub_categories.3d_architecture.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.3d_industrial_design.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.3d_fashion_and_garment.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.3d_printing_characters.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.3d_landscape.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.3d_game_art.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.3d_jewelry_design.designation'),
                            ),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.print_design.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(
                                array('designation' => 'messages.business_grand_child_sub_categories.flyer_design.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.brochure_design.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.poster_design.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.catalog_design.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.menu_design.designation'),
                            ),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.packaging_and_covers.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(
                                array('designation' => 'messages.business_grand_child_sub_categories.packaging_and_label_design.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.book_design.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.book_covers.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.album_cover_design.designation'),
                            ),
                        ),
                    ),
                ),
                array(
                    'designation' => 'messages.business_sub_categories.digital_marketing.designation',
                    'code' => "torryme.business_sub_category_codes.digital_marketing",
                    'description' => 'messages.business_sub_categories.digital_marketing.description',
                    'child_sub_categories' => array(
                        array(
                            'designation' => 'messages.business_child_sub_categories.search.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(
                                array('designation' => 'messages.business_grand_child_sub_categories.search_engine_optimization.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.search_engine_marketing.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.local_seo.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.e_commerce_seo.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.video_seo.designation'),
                            ),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.social.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(
                                array('designation' => 'messages.business_grand_child_sub_categories.social_media_marketing.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.paid_social_media.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.influencer_marketing.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.community_management.designation'),
                            ),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.methods_and_techniques.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(
                                array('designation' => 'messages.business_grand_child_sub_categories.video_marketing.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.e_commerce_marketing.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.email_marketing.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.guest_posting.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.affiliate_marketing.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.display_advertising.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.public_relations.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.text_message_marketing.designation'),
                            ),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.analytics_and_strategy.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(
                                array('designation' => 'messages.business_grand_child_sub_categories.marketing_strategy.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.marketing_advice.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.web_analytics.designation'),
                            ),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.purpose_specific.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(
                                array('designation' => 'messages.business_grand_child_sub_categories.music_promotion.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.podcast_marketing.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.book_and_eBook_marketing.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.mobile_app_marketing.designation'),
                            ),
                        ),
                    ),
                ),
                array(
                    'designation' => 'messages.business_sub_categories.writing_and_translation.designation',
                    'code' => "torryme.business_sub_category_codes.writing_and_translation",
                    'description' => 'messages.business_sub_categories.writing_and_translation.description',
                    'child_sub_categories' => array(
                        array(
                            'designation' => 'messages.business_child_sub_categories.articles_and_blog_posts.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.translation.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.proofreading_and_editing.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.resume_writing.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.cover_letters.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.linkedIn_profiles.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.ad_copy.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.sales_copy.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.social_media_copy.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.email_copy.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.case_studies.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.Book_and_eBook_writing.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.book_editing.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.scriptwriting.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.podcast_writing.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.beta_reading.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.creative_writing.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.brand_voice_and_tone.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.ux_writing.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.speech_writing.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.eLearning_content_development.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.technical_writing.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.job_descriptions.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.white_papers.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.website_content.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.product_descriptions.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.press_releases.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.business_names_and_slogans.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.grant_writing.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.transcription.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.research_and_summaries.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.writing_advice.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                    ),
                ),
                array(
                    'designation' => 'messages.business_sub_categories.video_and_animation.designation',
                    'code' => "torryme.business_sub_category_codes.video_and_animation",
                    'description' => 'messages.business_sub_categories.video_and_animation.description',
                    'child_sub_categories' => array(
                        array(
                            'designation' => 'messages.business_child_sub_categories.video_editing.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.producers_and_composers.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.animated_explainers.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.character_animation.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.music_videos.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.logo_animation.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.lottie_and_web_animation.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.intro_and_outro_videos.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.visual_effects.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.rigging.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.subtitles_and_captions.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.app_and_website_previews.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.3d_product_animation.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.social_media_videos.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.ecommerce_product_videos.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.spokesperson_videos.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.animated_gifs.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.unboxing_videos.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.corporate_videos.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.slideshow_videos.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.crowdfunding_videos.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.meditation_videos.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.videographers.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.filmed_video_production.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.live_action_explainers.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.game_trailers.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.book_trailers.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.nft_animation.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.animation_for_streamers.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.animation_for_kids.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.article_to_video.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.real_estate_promos.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.eLearning_video_production.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.video_templates_editing.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.screencast_videos.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.video_advice.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                    ),
                ),
                array(
                    'designation' => 'messages.business_sub_categories.music_and_audio.designation',
                    'code' => "torryme.business_sub_category_codes.music_and_audio",
                    'description' => 'messages.business_sub_categories.music_and_audio.description',
                    'child_sub_categories' => array(
                        array(
                            'designation' => 'messages.business_child_sub_categories.producers_and_composers_audio.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.mixing_and_mastering.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.singers_and_vocalists.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.session_musicians.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.songwriters.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.beat_making.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.jingles_and_intros.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.online_music_lessons.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.music_transcription.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.remixing_and_mashups.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.meditation_music.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.synth_presets.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.voice_over.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.podcast_production.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.audiobook_production.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.sound_design.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.audio_editing.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.audio_ads_production.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.dj_drops_and_tgs.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.dj_mixing.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.audio_logo_and_sonic_branding.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.vocal_tuning.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.music_and_audio_advice.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.voice_synthesis_and_ai.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(),
                        ),

                    ),
                ),
                array(
                    'designation' => 'messages.business_sub_categories.programming_and_tech.designation',
                    'code' => "torryme.business_sub_category_codes.programming_and_tech",
                    'description' => 'messages.business_sub_categories.programming_and_tech.description',
                    'child_sub_categories' => array(
                        array(
                            'designation' => 'messages.business_child_sub_categories.websites.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(
                                array('designation' => 'messages.business_grand_child_sub_categories.website_development.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.website_maintenance.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.business_websites.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.e_commerce_development.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.landing_pages.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.blogs.designation'),
                            ),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.website_platforms.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(
                                array('designation' => 'messages.business_grand_child_sub_categories.wordPress.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.shopify.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.wix.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.custom_websites.designation'),
                            ),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.application_development.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(
                                array('designation' => 'messages.business_grand_child_sub_categories.software_development.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.mobile_apps.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.web_applications.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.desktop_applications.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.game_development.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.ai_applications.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.catboats_development.designation'),
                            ),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.Support_and_cyber_security.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(
                                array('designation' => 'messages.business_grand_child_sub_categories.devOps_and_cloud.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.support_and_it.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.cybersecurity.designation'),
                            ),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.data.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(
                                array('designation' => 'messages.business_grand_child_sub_categories.databases.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.data_processing.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.data_engineering.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.data_science_and_ai.designation'),
                            ),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.more_options_programming_and_tech.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(
                                array('designation' => 'messages.business_grand_child_sub_categories.electronics_engineering.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.qa_and_review.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.user_testing.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.convert_files.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.blockchain_and_cryptocurrency.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.nft_development.designation'),
                            ),
                        ),
                    ),
                ),
                array(
                    'designation' => 'messages.business_sub_categories.photography.designation',
                    'code' => "torryme.business_sub_category_codes.photography",
                    'description' => 'messages.business_sub_categories.photography.description',
                    'child_sub_categories' => array(
                        array(
                            'designation' => 'messages.business_child_sub_categories.products_and_lifestyle.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(
                                array('designation' => 'messages.business_grand_child_sub_categories.product_photographers.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.food_photographers.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.Lifestyle_and_fashion_photographers.designation'),
                            ),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.people_and_scenes.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(
                                array('designation' => 'messages.business_grand_child_sub_categories.portrait_photographers.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.event_photographers.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.real_estate_photographers.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.aerial_photographers.designation'),
                            ),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.more_options_photography.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(
                                array('designation' => 'messages.business_grand_child_sub_categories.photography_classes.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.photography_image_editing.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.modeling_and_acting.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.styling_and_beauty.designation'),
                            ),
                        ),
                    ),
                ),
                array(
                    'designation' => 'messages.business_sub_categories.business.designation',
                    'code' => "torryme.business_sub_category_codes.business",
                    'description' => 'messages.business_sub_categories.business.description',
                    'child_sub_categories' => array(
                        array(
                            'designation' => 'messages.business_child_sub_categories.business_formation.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(
                                array('designation' => 'messages.business_grand_child_sub_categories.business_registration.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.business_plans.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.pitch_decks.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.startup_consulting.designation'),
                            ),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.legal_services.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(
                                array('designation' => 'messages.business_grand_child_sub_categories.applications_and_registrations.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.legal_documents_and_contracts.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.legal_consulting.designation'),
                            ),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.general_and_administrative.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(
                                array('designation' => 'messages.business_grand_child_sub_categories.data_entry.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.virtual_assistant.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.e_commerce_management.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.hr_consulting.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.project_management.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.supply_chain_management.designation'),
                            ),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.business_and_growth.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(
                                array('designation' => 'messages.business_grand_child_sub_categories.business_consulting.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.market_research.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.data_analytics.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.data_visualization.designation'),
                            ),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.sales_and_customer_care.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(
                                array('designation' => 'messages.business_grand_child_sub_categories.sales.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.lead_generation.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.call_center_and_calling.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.customer_care.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.crm_management.designation'),
                            ),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.professional_development.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(
                                array('designation' => 'messages.business_grand_child_sub_categories.interview_prep.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.leadership_development.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.life_coaching.designation'),
                            ),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.accounting_and_finance.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(
                                array('designation' => 'messages.business_grand_child_sub_categories.tax_consulting.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.accounting_and_bookkeeping.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.financial_consulting.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.erp_management.designation'),
                            ),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.more_options_business.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(
                                array('designation' => 'messages.business_grand_child_sub_categories.fact_checking.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.event_management.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.game_concept_design.designation'),
                            ),
                        ),
                    ),
                ),
                array(
                    'designation' => 'messages.business_sub_categories.ai_services.designation',
                    'code' => "torryme.business_sub_category_codes.ai_services",
                    'description' => 'messages.business_sub_categories.ai_services.description',
                    'child_sub_categories' => array(
                        array(
                            'designation' => 'messages.business_child_sub_categories.ai_artists.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(
                                array('designation' => 'messages.business_grand_child_sub_categories.midjourney_artists.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.dall_e_artists.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.stable_diffusion_artists.designation'),
                            ),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.ai_applications.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(
                                array('designation' => 'messages.business_grand_child_sub_categories.chat_gpt_applications.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.ai_web_applications.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.ai_chatbots.designation'),
                            ),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.other_services.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(
                                array('designation' => 'messages.business_grand_child_sub_categories.ai_models.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.ai_music_videos.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.ai_content_editing.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.ai_fact_checking.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.Voice_synthesis_and_ai.designation'),
                            ),
                        ),
                    ),
                ),
            ),
            'base_attributes' => array(),
        ),
        'cinema' => array(
            'designation' => 'messages.business_categories.cinema.designation',
            'code' => "torryme.business_category_codes.cinema",
            'description' => 'messages.business_categories.cinema.description',
            'sub_categories' => array(
                array(
                    'designation' => 'messages.business_sub_categories.cinema.designation',
                    'code' => "torryme.business_sub_category_codes.cinema",
                    'description' => 'messages.business_sub_categories.cinema.description',
                    'child_sub_categories' => array(
                        array(
                            'designation' => 'messages.business_child_sub_categories.movies.designation',
                            'code' => "torryme.business_sub_category_child_codes.movie",
                            'grand_child_sub_categories' => array(
                                array('designation' => 'messages.business_grand_child_sub_categories.action_film.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.comedy.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.cinema_horror.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.sci_fi_movie.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.western_film.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.cinema_romance.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.cinema_thriller.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.cinema_fantasy.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.historical_movie.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.crime_and_mystery.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.cinema_drama.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.animation.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.experimental_film.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.other_film_genres.designation'),
                            ),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.series.designation',
                            'code' => "torryme.business_sub_category_child_codes.series",
                            'grand_child_sub_categories' => array(
                                array('designation' => 'messages.business_grand_child_sub_categories.action_film.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.comedy.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.cinema_horror.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.sci_fi_movie.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.western_film.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.cinema_romance.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.cinema_thriller.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.cinema_fantasy.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.historical_movie.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.crime_and_mystery.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.cinema_drama.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.animation.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.experimental_film.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.other_film_genres.designation'),
                            ),
                        ),
                    ),
                ),
            ),
            'base_attributes' => array(),
        ),
        'music' => array(
            'designation' => 'messages.business_categories.music.designation',
            'code' => "torryme.business_category_codes.music",
            'description' => 'messages.business_categories.music.description',
            'sub_categories' => array(
                array(
                    'designation' => 'messages.business_sub_categories.music.designation',
                    'code' => "torryme.business_sub_category_codes.music",
                    'description' => 'messages.business_sub_categories.music.description',
                    'child_sub_categories' => array(
                        array(
                            'designation' => 'messages.business_child_sub_categories.video.designation',
                            'code' => "torryme.business_sub_category_child_codes.video_music",
                            'grand_child_sub_categories' => array(
                                array('designation' => 'messages.business_grand_child_sub_categories.popular_music.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.pop_music.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.rock.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.hip_hop_music.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.rhythm_and_blues.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.country_music.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.jazz.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.classical_music.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.blues.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.electronic_music.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.dance_music.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.heavy_metal.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.electronic_dance_music.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.soul_music.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.folk_music.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.indie_rock_funk.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.alternative_rock.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.reggae.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.reggaeton.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.world_music.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.singing.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.musical_theatre.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.music_of_latin_america.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.techno.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.punk_rock.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.new_age_music.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.disco.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.easy_listening.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.pop_rock.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.latin_music.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.dubstep.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.house_music.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.progressive_rock.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.contemporary_r_and_b.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.rock_and_roll.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.music_of_the_united_states.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.ska.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.opera.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.trance_music.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.african_american_music.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.electro.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.instrumental.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.salsa_music.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.soundtrack.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.k_pop.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.vocal_music.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.art_music.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.childrens_music.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.bikutsi.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.flamenco.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.experimental_music.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.amapiano.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.jùjú.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.fuji.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.afrobeat.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.highlife.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.makossa.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.kizomba.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.cultural_music.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.ndombollo.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.coupe_decale.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.other_genre.designation'),
                            ),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.audio.designation',
                            'code' => "torryme.business_sub_category_child_codes.audio_music",
                            'grand_child_sub_categories' => array(
                                array('designation' => 'messages.business_grand_child_sub_categories.popular_music.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.pop_music.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.rock.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.hip_hop_music.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.rhythm_and_blues.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.country_music.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.jazz.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.classical_music.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.blues.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.electronic_music.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.dance_music.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.heavy_metal.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.electronic_dance_music.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.soul_music.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.folk_music.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.indie_rock_funk.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.alternative_rock.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.reggae.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.reggaeton.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.world_music.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.singing.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.musical_theatre.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.music_of_latin_america.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.techno.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.punk_rock.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.new_age_music.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.disco.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.easy_listening.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.pop_rock.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.latin_music.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.dubstep.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.house_music.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.progressive_rock.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.contemporary_r_and_b.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.rock_and_roll.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.music_of_the_united_states.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.ska.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.opera.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.trance_music.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.african_american_music.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.electro.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.instrumental.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.salsa_music.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.soundtrack.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.k_pop.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.vocal_music.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.art_music.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.childrens_music.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.bikutsi.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.flamenco.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.experimental_music.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.amapiano.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.jùjú.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.fuji.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.afrobeat.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.highlife.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.makossa.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.kizomba.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.cultural_music.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.ndombollo.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.coupe_decale.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.other_genre.designation'),
                            ),
                        ),
                    ),
                ),
            ),
            'base_attributes' => array(),
        ),
        'library' => array(
            'designation' => 'messages.business_categories.library.designation',
            'code' => "torryme.business_category_codes.library",
            'description' => 'messages.business_categories.library.description',
            'sub_categories' => array(
                array(
                    'designation' => 'messages.business_sub_categories.library.designation',
                    'code' => "torryme.business_sub_category_codes.library",
                    'description' => 'messages.business_sub_categories.library.description',
                    'child_sub_categories' => array(
                        array(
                            'designation' => 'messages.business_child_sub_categories.hard_copy.designation',
                            'code' => "torryme.business_sub_category_child_codes.hard_copy",
                            'grand_child_sub_categories' => array(
                                array('designation' => 'messages.business_grand_child_sub_categories.action_and_adventure.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.art_architecture.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.alternate_history.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.autobiography.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.anthology.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.biography.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.chick_lit.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.business_economics.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.Childrens.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.crafts_hobbies.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.classic.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.cookbook.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.comic_book.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.diary.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.coming_of_age.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.dictionary.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.crime.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.encyclopedia.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.drama.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.guide.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.fairytale.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.health_fitness.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.fantasy.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.history.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.graphic_novel.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.home_and_garden.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.historical_fiction.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.humor.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.horror.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.journal.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.mystery.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.math.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.paranormal_romance.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.memoir.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.picture_book.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.philosophy.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.poetry.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.prayer.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.political_thrillers.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.religion_spirituality_and_new_age.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.romance.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.textbook.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.satire.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.true_crime.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.science_fiction.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.review.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.short_story.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.science.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.suspense.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.self_help.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.thriller.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.sports_and_leisure.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.western.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.travel.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.young_adult.designation'),
                            ),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.ebooks.designation',
                            'code' => "torryme.business_sub_category_child_codes.ebook",
                            'grand_child_sub_categories' => array(
                                array('designation' => 'messages.business_grand_child_sub_categories.action_and_adventure.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.art_architecture.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.alternate_history.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.autobiography.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.anthology.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.biography.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.chick_lit.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.business_economics.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.Childrens.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.crafts_hobbies.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.classic.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.cookbook.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.comic_book.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.diary.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.coming_of_age.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.dictionary.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.crime.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.encyclopedia.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.drama.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.guide.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.fairytale.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.health_fitness.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.fantasy.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.history.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.graphic_novel.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.home_and_garden.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.historical_fiction.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.humor.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.horror.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.journal.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.mystery.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.math.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.paranormal_romance.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.memoir.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.picture_book.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.philosophy.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.poetry.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.prayer.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.political_thrillers.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.religion_spirituality_and_new_age.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.romance.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.textbook.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.satire.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.true_crime.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.science_fiction.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.review.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.short_story.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.science.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.suspense.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.self_help.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.thriller.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.sports_and_leisure.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.western.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.travel.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.young_adult.designation'),
                            ),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.audio_books.designation',
                            'code' => "torryme.business_sub_category_child_codes.audio_book",
                            'grand_child_sub_categories' => array(
                                array('designation' => 'messages.business_grand_child_sub_categories.action_and_adventure.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.art_architecture.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.alternate_history.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.autobiography.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.anthology.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.biography.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.chick_lit.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.business_economics.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.Childrens.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.crafts_hobbies.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.classic.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.cookbook.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.comic_book.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.diary.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.coming_of_age.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.dictionary.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.crime.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.encyclopedia.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.drama.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.guide.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.fairytale.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.health_fitness.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.fantasy.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.history.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.graphic_novel.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.home_and_garden.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.historical_fiction.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.humor.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.horror.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.journal.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.mystery.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.math.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.paranormal_romance.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.memoir.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.picture_book.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.philosophy.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.poetry.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.prayer.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.political_thrillers.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.religion_spirituality_and_new_age.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.romance.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.textbook.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.satire.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.true_crime.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.science_fiction.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.review.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.short_story.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.science.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.suspense.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.self_help.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.thriller.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.sports_and_leisure.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.western.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.travel.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.young_adult.designation'),
                            ),
                        ),
                    ),
                ),
            ),
            'base_attributes' => array(
                'Color' => array(
                    'designation' => 'messages.base_attributes.color',
                    'type' => AttributeTypeEnum::color->value,
                    'business_id' => null,
                    'attribute_si_units' => array(),
                ),
            ),
        ),
        'games' => array(
            'designation' => 'messages.business_categories.games.designation',
            'code' => "torryme.business_category_codes.game",
            'description' => 'messages.business_categories.games.description',
            'sub_categories' => array(
                array(
                    'designation' => 'messages.business_sub_categories.pc.designation',
                    'code' => "torryme.business_sub_category_codes.pc",
                    'description' => 'messages.business_sub_categories.pc.description',
                    'child_sub_categories' => array(
                        array(
                            'designation' => 'messages.business_child_sub_categories.standard_edition.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(
                                array('designation' => 'messages.business_grand_child_sub_categories.action_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.adventure_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.castle_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.casual_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.match_3_ames.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.medieval_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.mmo_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.mmorpg_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.multiplayer_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.puzzle_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.pvp_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.robot_ames.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.rpg_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.shooters.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.solitaire_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.strategy_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.survival_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.war_games.designation'),
                            ),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.deluxe_edition.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(
                                array('designation' => 'messages.business_grand_child_sub_categories.action_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.adventure_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.castle_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.casual_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.match_3_ames.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.medieval_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.mmo_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.mmorpg_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.multiplayer_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.puzzle_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.pvp_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.robot_ames.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.rpg_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.shooters.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.solitaire_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.strategy_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.survival_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.war_games.designation'),
                            ),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.gold_edition.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(
                                array('designation' => 'messages.business_grand_child_sub_categories.action_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.adventure_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.castle_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.casual_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.match_3_ames.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.medieval_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.mmo_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.mmorpg_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.multiplayer_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.puzzle_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.pvp_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.robot_ames.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.rpg_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.shooters.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.solitaire_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.strategy_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.survival_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.war_games.designation'),
                            ),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.game_of_the_year_edition.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(
                                array('designation' => 'messages.business_grand_child_sub_categories.action_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.adventure_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.castle_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.casual_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.match_3_ames.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.medieval_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.mmo_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.mmorpg_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.multiplayer_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.puzzle_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.pvp_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.robot_ames.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.rpg_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.shooters.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.solitaire_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.strategy_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.survival_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.war_games.designation'),
                            ),
                        ),
                    ),
                ),
                array(
                    'designation' => 'messages.business_sub_categories.ps4.designation',
                    'code' => "torryme.business_sub_category_codes.ps4",
                    'description' => 'messages.business_sub_categories.ps4.description',
                    'child_sub_categories' => array(
                        array(
                            'designation' => 'messages.business_child_sub_categories.standard_edition.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(
                                array('designation' => 'messages.business_grand_child_sub_categories.action_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.adventure_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.castle_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.casual_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.match_3_ames.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.medieval_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.mmo_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.mmorpg_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.multiplayer_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.puzzle_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.pvp_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.robot_ames.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.rpg_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.shooters.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.solitaire_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.strategy_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.survival_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.war_games.designation'),
                            ),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.deluxe_edition.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(
                                array('designation' => 'messages.business_grand_child_sub_categories.action_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.adventure_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.castle_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.casual_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.match_3_ames.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.medieval_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.mmo_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.mmorpg_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.multiplayer_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.puzzle_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.pvp_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.robot_ames.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.rpg_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.shooters.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.solitaire_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.strategy_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.survival_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.war_games.designation'),
                            ),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.gold_edition.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(
                                array('designation' => 'messages.business_grand_child_sub_categories.action_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.adventure_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.castle_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.casual_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.match_3_ames.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.medieval_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.mmo_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.mmorpg_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.multiplayer_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.puzzle_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.pvp_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.robot_ames.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.rpg_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.shooters.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.solitaire_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.strategy_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.survival_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.war_games.designation'),
                            ),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.game_of_the_year_edition.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(
                                array('designation' => 'messages.business_grand_child_sub_categories.action_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.adventure_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.castle_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.casual_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.match_3_ames.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.medieval_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.mmo_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.mmorpg_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.multiplayer_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.puzzle_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.pvp_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.robot_ames.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.rpg_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.shooters.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.solitaire_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.strategy_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.survival_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.war_games.designation'),
                            ),
                        ),
                    ),
                ),
                array(
                    'designation' => 'messages.business_sub_categories.ps5.designation',
                    'code' => "torryme.business_sub_category_codes.ps5",
                    'description' => 'messages.business_sub_categories.ps5.description',
                    'child_sub_categories' => array(
                        array(
                            'designation' => 'messages.business_child_sub_categories.standard_edition.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(
                                array('designation' => 'messages.business_grand_child_sub_categories.action_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.adventure_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.castle_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.casual_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.match_3_ames.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.medieval_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.mmo_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.mmorpg_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.multiplayer_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.puzzle_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.pvp_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.robot_ames.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.rpg_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.shooters.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.solitaire_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.strategy_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.survival_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.war_games.designation'),
                            ),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.deluxe_edition.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(
                                array('designation' => 'messages.business_grand_child_sub_categories.action_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.adventure_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.castle_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.casual_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.match_3_ames.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.medieval_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.mmo_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.mmorpg_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.multiplayer_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.puzzle_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.pvp_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.robot_ames.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.rpg_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.shooters.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.solitaire_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.strategy_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.survival_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.war_games.designation'),
                            ),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.gold_edition.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(
                                array('designation' => 'messages.business_grand_child_sub_categories.action_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.adventure_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.castle_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.casual_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.match_3_ames.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.medieval_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.mmo_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.mmorpg_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.multiplayer_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.puzzle_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.pvp_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.robot_ames.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.rpg_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.shooters.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.solitaire_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.strategy_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.survival_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.war_games.designation'),
                            ),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.game_of_the_year_edition.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(
                                array('designation' => 'messages.business_grand_child_sub_categories.action_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.adventure_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.castle_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.casual_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.match_3_ames.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.medieval_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.mmo_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.mmorpg_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.multiplayer_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.puzzle_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.pvp_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.robot_ames.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.rpg_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.shooters.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.solitaire_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.strategy_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.survival_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.war_games.designation'),
                            ),
                        ),
                    ),
                ),
                array(
                    'designation' => 'messages.business_sub_categories.xbox.designation',
                    'code' => "torryme.business_sub_category_codes.xbox",
                    'description' => 'messages.business_sub_categories.xbox.description',
                    'child_sub_categories' => array(
                        array(
                            'designation' => 'messages.business_child_sub_categories.standard_edition.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(
                                array('designation' => 'messages.business_grand_child_sub_categories.action_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.adventure_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.castle_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.casual_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.match_3_ames.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.medieval_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.mmo_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.mmorpg_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.multiplayer_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.puzzle_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.pvp_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.robot_ames.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.rpg_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.shooters.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.solitaire_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.strategy_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.survival_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.war_games.designation'),
                            ),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.deluxe_edition.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(
                                array('designation' => 'messages.business_grand_child_sub_categories.action_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.adventure_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.castle_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.casual_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.match_3_ames.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.medieval_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.mmo_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.mmorpg_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.multiplayer_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.puzzle_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.pvp_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.robot_ames.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.rpg_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.shooters.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.solitaire_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.strategy_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.survival_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.war_games.designation'),
                            ),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.gold_edition.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(
                                array('designation' => 'messages.business_grand_child_sub_categories.action_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.adventure_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.castle_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.casual_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.match_3_ames.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.medieval_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.mmo_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.mmorpg_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.multiplayer_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.puzzle_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.pvp_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.robot_ames.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.rpg_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.shooters.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.solitaire_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.strategy_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.survival_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.war_games.designation'),
                            ),
                        ),
                        array(
                            'designation' => 'messages.business_child_sub_categories.game_of_the_year_edition.designation',
                            'code' => null,
                            'grand_child_sub_categories' => array(
                                array('designation' => 'messages.business_grand_child_sub_categories.action_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.adventure_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.castle_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.casual_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.match_3_ames.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.medieval_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.mmo_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.mmorpg_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.multiplayer_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.puzzle_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.pvp_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.robot_ames.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.rpg_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.shooters.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.solitaire_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.strategy_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.survival_games.designation'),
                                array('designation' => 'messages.business_grand_child_sub_categories.war_games.designation'),
                            ),
                        ),
                    ),
                ),
            ),
            'base_attributes' => array(),
        ),
        'affiliate' => array(
            'designation' => 'messages.business_categories.affiliate.designation',
            'code' => "torryme.business_category_codes.affiliate",
            'description' => 'messages.business_categories.affiliate.description',
            'sub_categories' => array(),
            'base_attributes' => array(),
        ),
    ],
];
