<?php

namespace App\Services;

use App\Models\User;
use App\Models\UserDevice;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;

trait UserDeviceService
{
    /**
     * Store new record
     *
     * @param array $data
     * @return Builder|Model
     */
    public static function store(array $data): Model|Builder
    {
        return UserDevice::query()->create($data);
    }

    /**
     * Update existing record
     *
     * @param array $data
     * @return mixed
     */
    public function updateService(array $data): mixed
    {
        return tap($this)->update($data);
    }

    /**
     * Get user device
     *
     * @param User $user
     * @return mixed
     */
    public static function lastUserDevice(User $user): mixed
    {
        return $user->{'userDevice'};
    }

    /**
     * Find by native device
     *
     * @param string $nativeId
     * @return Builder|Model|null
     */
    public static function findByNativeId(string $nativeId): Model|Builder|null
    {
        return UserDevice::query()->where('native_device_id', $nativeId)->first();
    }

    /**
     * Checking native device id
     *
     * @param string $nativeId
     * @return bool
     */
    public function hasSameDeviceId(string $nativeId): bool
    {
        return $this->{'native_device_id'} === $nativeId;
    }
}
