<?php

namespace App\Services;

use App\Models\Transaction;
use App\Models\Wallet;
use Illuminate\Contracts\Pagination\LengthAwarePaginator;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;

trait TransactionService
{
   /**
    * Store new record
    *
    * @param array $data
    * @return Builder|Model
    */
   public static function store(array $data): Model|Builder
   {
      return Transaction::query()->create($data);
   }

   /**
    * Update existing record
    *
    * @param array $data
    * @return mixed
    */
   public function updateService(array $data): mixed
   {
      return tap($this)->update($data);
   }

   /**
    * Find by id
    *
    * @param int $id
    * @return Builder|Builder[]|Collection|Model|null
    */
   public static function findById(int $id): Model|Collection|Builder|array|null
   {
      return Transaction::query()->find($id);
   }

   /**
    * Return all user transactions
    *
    * @param Wallet $wallet
    * @param string|null $type
    * @param int|null $page
    * @return LengthAwarePaginator
    */
   public static function allUserTransactions(Wallet $wallet, string $type = null, int $page = null): LengthAwarePaginator
   {
      // Source data ...
      $queryBuilder = Transaction::query()->with(["externalSourceAccount"]);

      $queryBuilder =
         $queryBuilder
            ->when($type !== null, function ($builder) use($type) {
               $builder->where('type', $type);
            })
            ->where(function (Builder $builder) use ($wallet) {
               $builder
                  ->orWhere('source_wallet_id', $wallet->{'id'})
                  ->orWhere('destination_wallet_id', $wallet->{'id'});
            })->orderByDesc('created_at');

      return $queryBuilder->paginate(
         perPage: config("torryme.constants.items_per_page"),
         columns: ['*'],
         pageName: 'page',
         page: $page
      );
   }
}
