<?php

namespace App\Services;

use App\Enums\ReportedProblemStatusEnum;
use App\Models\ReportedProblem;
use App\Models\User;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;

trait ReportedProblemService
{
    /**
     * Store new record
     *
     * @param array $data
     * @return Builder|Model
     */
    public static function store(array $data): Model|Builder
    {
        return ReportedProblem::query()->create($data);
    }

    /**
     * Update existing record
     *
     * @param array $data
     * @return mixed
     */
    public function updateService(array $data): mixed
    {
        return tap($this)->update($data);
    }

    /**
     * Create report problem
     *
     * @param string $problem
     * @return Builder|Model
     */
    public static function createReportProblem(string $problem): Model|Builder
    {
        /** @var User $user */
        $user = auth()->user();

        return ReportedProblem::store([
            "problem_description" => $problem,
            "status" => ReportedProblemStatusEnum::pending->value,
            "user_id" => $user->{"id"},
        ]);
    }

}
