<?php

namespace App\Services;

use App\Models\Chat;
use App\Models\RealtimeParticipant;
use App\Models\User;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;

trait RealtimeParticipantService
{
    /**
     * Store new record
     *
     * @param array $data
     * @return Builder|Model
     */
    public static function store(array $data): Model|Builder
    {
        return RealtimeParticipant::query()->create($data);
    }

    /**
     * Update existing record
     *
     * @param array $data
     * @return mixed
     */
    public function updateService(array $data): mixed
    {
        return tap($this)->update($data);
    }

    /**
     * Find or create new participant
     *
     * @param Chat $chat
     * @param User $user
     * @return Builder|Model|null
     */
    public static function findOrCreate(User $user, Chat $chat): Model|Builder|null
    {
        $participant =
            RealtimeParticipant::query()
                ->where('chat_id', $chat->{'id'})
                ->where('participant_id', $user->{'id'})
                ->first();

        if($participant === null) {
            $participant = self::store([
                'chat_id' => $chat->{'id'},
                'participant_id' => $user->{'id'},
            ]);
        }

        return $participant;
    }
}
