<?php

namespace App\Services;

use App\Models\ProductHashTag;
use App\Models\User;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;

trait ProductHashTagService
{
    /**
     * Store new record
     *
     * @param array $data
     * @return Builder|Model
     */
    public static function store(array $data): Model|Builder
    {
        return ProductHashTag::query()->create($data);
    }

    /**
     * Update existing record
     *
     * @param array $data
     * @return mixed
     */
    public function updateService(array $data): mixed
    {
        return tap($this)->update($data);
    }

    /**
     * Get most used business hashtags
     *
     * @return Builder[]|Collection
     */
    public static function mostUsedHashTags(): Collection|array
    {
        /** @var User $user */
        $user = auth()->user();

        $productHastTags =
            ProductHashTag::query()
                ->with("hashTag")
                ->whereHas("business", function (Builder $builder) use ($user) {
                    $builder->where('id', $user->{"business"}?->{"id"});
                })
                ->select('hash_tag_id')
                ->selectRaw('COUNT(*) AS occurrences')
                ->groupBy('hash_tag_id')
                ->orderByDesc('occurrences')
                ->limit(config("torryme.constants.max_number_of_most_used_product_hash_tags"))
                ->get();

        $productHastTagArray = array();
        foreach ($productHastTags as $productHastTag) {
            $productHastTagArray[] = $productHastTag->{"hashTag"}->{"designation"};
        }

        return $productHastTagArray;
    }
}
