<?php

namespace App\Services;

use App\Models\PostAttachment;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;

trait PostAttachmentService
{
    /**
     * Store new record
     *
     * @param array $data
     * @return Builder|Model
     */
    public static function store(array $data): Model|Builder
    {
        return PostAttachment::query()->create($data);
    }

    /**
     * Update existing record
     *
     * @param array $data
     * @return mixed
     */
    public function updateService(array $data): mixed
    {
        return tap($this)->update($data);
    }

    /**
     * Find by id
     *
     * @param int $postId
     * @return Builder|Builder[]|Collection|Model|null
     */
    public static function findById(int $postId): Model|Collection|Builder|array|null
    {
        return PostAttachment::query()->find($postId);
    }
}
