<?php

namespace App\Services;

use App\Models\PasswordChangeHistory;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;

trait PasswordChangeHistoryService
{
    /**
     * Store new record
     *
     * @param array $data
     * @return Builder|Model
     */
    public static function store(array $data): Model|Builder
    {
        return PasswordChangeHistory::query()->create($data);
    }

    /**
     * Update existing record
     *
     * @param array $data
     * @return mixed
     */
    public function updateService(array $data): mixed
    {
        return tap($this)->update($data);
    }

    /**
     * Get last password change history
     *
     * @param int $userId
     * @return Model|Builder|null
     */
    public static function getLastChangeHistory(int $userId): Model|Builder|null
    {
        return PasswordChangeHistory::query()->where("user_id", $userId)->latest()->first();
    }

}
