<?php

namespace App\Services;

use App\Models\OrderDetailAttribute;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;

trait OrderDetailAttributeService
{
    /**
     * Store new record
     *
     * @param array $data
     * @return Builder|Model
     */
    public static function store(array $data): Model|Builder
    {
        return OrderDetailAttribute::query()->create($data);
    }

    /**
     * Update existing record
     *
     * @param array $data
     * @return mixed
     */
    public function updateService(array $data): mixed
    {
        return tap($this)->update($data);
    }

    /**
     * Compute attribute for request details
     *
     * @return array
     */
    public function computeForDetails(): array
    {
        $orderAttribute = $this;

        $attributeValue = $orderAttribute->{'attributeValue'};
        $attributeSIUnit = $attributeValue?->{'attributeSIUnit'};
        $linkAttribute = $orderAttribute->{'attribute'} ?? $attributeValue->{'attribute'};

        return array(
            'attribute' => [
                'id' => $linkAttribute->{'id'},
                'type' => $linkAttribute->{'type'},
                'designation' => $linkAttribute->{'designation'},
            ],
            'attribute_value' => $attributeValue !== null ? [
                'id' => $attributeValue?->{'id'},
                'si_unit' => [
                    'id' => $attributeSIUnit->{'id'},
                    'si_unit' => $attributeSIUnit->{'si_unit'},
                    'si_unit_designation' => $attributeSIUnit->{'si_unit_designation'},
                ]
            ] : null,
            'values' => [
                'id' => $orderAttribute->{'id'},
                'value' => $orderAttribute->{'value'},
                'extra_value' => $orderAttribute->{'extra_value'},
                'additional_price' => $orderAttribute->{'additional_price'},
                'additional_price_currency' => $orderAttribute->{'additionalPriceCurrency'}?->{'code'},
            ]
        );
    }
}
