<?php

namespace App\Services;

use App\Models\MessageDeliveryHistory;
use App\Models\RealtimeMessage;
use App\Models\User;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;

trait MessageDeliveryHistoryService
{
   /**
    * Store new record
    *
    * @param array $data
    * @return Builder|Model
    */
   public static function store(array $data): Model|Builder
   {
      return MessageDeliveryHistory::query()->create($data);
   }

   /**
    * Serialize for channel
    *
    * @return array
    */
   public function serializeForChannel(): array
   {
      return array(
         'user_participant_id' => $this->{'participant'}->{'participant_id'},
         'delivered_at' => $this->{'delivered_at'}
      );
   }

   /**
    * Get delivered message history
    *
    * @param RealtimeMessage $message
    * @return array
    */
   public static function messageDeliveryHistory(RealtimeMessage $message): array
   {
      $histories = MessageDeliveryHistory::query()->where('message_id', $message->{'id'})->latest()->get();
      $result = [];

      foreach ($histories as $history) {
         $result[] = $history->serializeForChannel();
      }

      return $result;
   }

   /**
    * Last message delivery
    *
    * @param RealtimeMessage $message
    * @param User $user
    * @return Builder|Model|null
    */
   public static function lastMessageDelivery(RealtimeMessage $message, User $user): Model|Builder|null
   {
      return
         MessageDeliveryHistory::query()
            ->where('message_id', $message->{'id'})
            ->whereHas('participant.user', function (Builder $builder) use ($user) {
               $builder->where('id', $user->{'id'});
            })
            ->latest()
            ->first();
   }
}
