<?php

namespace App\Services;

use App\Models\HashTag;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;

trait HashTagService
{
    /**
     * Store new record
     *
     * @param array $data
     * @return Builder|Model
     */
    public static function store(array $data): Model|Builder
    {
        return HashTag::query()->create($data);
    }

    /**
     * Update existing record
     *
     * @param array $data
     * @return mixed
     */
    public function updateService(array $data): mixed
    {
        return tap($this)->update($data);
    }

    /**
     * Check if hashtag already exist
     *
     * @param string $hashtag
     * @return Model|Builder|null
     */
    public static function checkExist(string $hashtag): Model|Builder|null
    {
        return HashTag::query()->where("designation", '=', $hashtag)->first();
    }
}
