<?php

namespace App\Services;

use App\Models\ExchangeRate;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;

trait ExchangeRateService
{
    /**
     * Store new record
     *
     * @param array $data
     * @return Builder|Model
     */
    public static function store(array $data): Model|Builder
    {
        return ExchangeRate::query()->create($data);
    }

    /**
     * Update existing record
     *
     * @param array $data
     * @return mixed
     */
    public function updateService(array $data): mixed
    {
        return tap($this)->update($data);
    }

    /**
     * @param $sourceCurrency
     * @param $destinationCurrency
     * @return Model|Builder|null
     */
    public static function getExchangeRate($sourceCurrency, $destinationCurrency): Model|Builder|null
    {
        return ExchangeRate::query()->where("source_currency_id", $sourceCurrency)
            ->where("destination_currency_id", $destinationCurrency)
            ->first();
    }

}
