<?php

namespace App\Services;

use App\Models\DisputeType;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;

trait DisputeTypeService
{
   /**
    * Store new record
    *
    * @param array $data
    * @return Builder|Model
    */
   public static function store(array $data): Model|Builder
   {
      return DisputeType::query()->create($data);
   }

   /**
    * Update existing record
    *
    * @param array $data
    * @return mixed
    */
   public function updateService(array $data): mixed
   {
      return tap($this)->update($data);
   }

   /**
    * All disputes types
    *
    * @return mixed
    */
   public static function disputeTypes(): mixed
   {
      return DisputeType::query()->get();
   }
}
