<?php

namespace App\Services;

use App\Models\BusinessCategory;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;

trait BusinessCategoryService
{
    /**
     * Store new record
     *
     * @param array $data
     * @return Builder|Model
     */
    public static function store(array $data): Model|Builder
    {
        return BusinessCategory::query()->create($data);
    }

    /**
     * Update existing record
     *
     * @param array $data
     * @return mixed
     */
    public function updateService(array $data): mixed
    {
        return tap($this)->update($data);
    }

    /**
     * Find by id
     *
     * @param int $id
     * @return Builder|Builder[]|Collection|Model|null
     */
    public static function findById(int $id): Model|Collection|Builder|array|null
    {
        return BusinessCategory::query()->find($id);
    }

   /**
    * FInd by code
    *
    * @param string $code
    * @return Model|Builder|null
    */
    public static function findByCode(string $code): Model|Builder|null
    {
       return BusinessCategory::query()->where("code", $code)->first();
    }


    /**
     * Get all business categories
     *
     * @param array $excludeCodes
     * @return Collection|array
     */
    public static function allBusinessCategories(array $excludeCodes = []): Collection|array
    {
        return
            BusinessCategory::query()
                ->when(count($excludeCodes) > 0, function(Builder $builder) use($excludeCodes) {
                    $builder->whereNotIn("code", $excludeCodes);
                })
                ->whereNull("disabled_at")
                ->get();
    }

    /**
     * Get service category
     *
     * @return Model|Builder|null
     */
    public static function getServiceBusinessCategories (): Model|Builder|null
    {
        return BusinessCategory::query()->where('code', config('torryme.business_category_codes.service'))->first();
    }
}
