<?php

namespace App\Services;

use App\Models\AccountPrivacySetting;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;

trait AccountPrivacySettingService
{
   /**
    * Store new record
    *
    * @param array $data
    * @return Builder|Model
    */
   public static function store(array $data): Model|Builder
   {
      return AccountPrivacySetting::query()->create($data);
   }

   /**
    * Update existing record
    *
    * @param array $data
    * @return mixed
    */
   public function updateService(array $data): mixed
   {
      return tap($this)->update($data);
   }

   /**
    * Find by id
    *
    * @param int $id
    * @return Builder|Builder[]|Collection|Model|null
    */
   public static function findById(int $id): Model|Collection|Builder|array|null
   {
      return AccountPrivacySetting::query()->find($id);
   }

   /**
    * Edit account privacy settings
    *
    * @param array $data
    * @return AccountPrivacySetting|null
    */
   public function updatePrivacySettings(array $data): ?AccountPrivacySetting
   {
      $accountPrivacy = $this;

      try {
         $accountPrivacy = $accountPrivacy->updateService([
            "enable_privacy" => $data["enable_privacy"] ?? $accountPrivacy->{"enable_privacy"},
            "enable_2factor_auth" => $data["enable_2factor_auth"] ?? $accountPrivacy->{"enable_2factor_auth"},
            "who_can_comment" => $data["who_can_comment"] ?? $accountPrivacy->{"who_can_comment"},
            "who_can_mention" => $data["who_can_mention"] ?? $accountPrivacy->{"who_can_mention"},
            "who_can_see_follower_list" => $data["who_can_see_follower_list"] ?? $accountPrivacy->{"who_can_see_follower_list"},
            "who_can_invite_you_by_direct_message" => $data["who_can_invite_you_by_direct_message"] ?? $accountPrivacy->{"who_can_invite_you_by_direct_message"},
            "who_can_invite_you_into_community" => $data["who_can_invite_you_into_community"] ?? $accountPrivacy->{"who_can_invite_you_into_community"},
            "who_can_download_post" => $data["who_can_download_post"] ?? $accountPrivacy->{"who_can_download_post"},
         ]);

         $result = $accountPrivacy->refresh();
      } catch (\Exception $exception) {
         log_debug(exception: $exception, prefix: 'AccountPrivacySettingService::updatePrivacySettings');
         $result = null;
      }

      return $result;
   }
}
