<?php

namespace App\Services;

use App\Models\AccountNotificationSetting;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;

trait AccountNotificationSettingService
{
    /**
     * Store new record
     *
     * @param array $data
     * @return Builder|Model
     */
    public static function store(array $data): Model|Builder
    {
        return AccountNotificationSetting::query()->create($data);
    }

    /**
     * Update existing record
     *
     * @param array $data
     * @return mixed
     */
    public function updateService(array $data): mixed
    {
        return tap($this)->update($data);
    }

    /**
     * Update account notification settings
     *
     * @param array $data
     * @return mixed
     */
    public function updateNotificationSettings(array $data): mixed
    {
        $accountNotificationSetting = $this;
        try {
            $updatedAccountPrivacy = $accountNotificationSetting->updateService([
                "enable_push_notification" =>  $data["enable_push_notification"] ?? $accountNotificationSetting->{"enable_push_notification"},
                "new_orders" => $data["new_orders"] ?? $accountNotificationSetting->{"new_orders"},
                "likes" => $data["likes"] ?? $accountNotificationSetting->{"likes"},
                "comments" => $data["comments"] ?? $accountNotificationSetting->{"comments"},
                "shares" => $data["shares"] ?? $accountNotificationSetting->{"shares"},
                "reviews" => $data["reviews"] ?? $accountNotificationSetting->{"reviews"},
                "direct_messages" => $data["direct_messages"] ?? $accountNotificationSetting->{"direct_messages"},
                "post_from_subscribed_accounts" => $data["post_from_subscribed_accounts"] ?? $accountNotificationSetting->{"post_from_subscribed_accounts"},
                "live_stream_from_subscribed_accounts" => $data["live_stream_from_subscribed_accounts"] ?? $accountNotificationSetting->{"live_stream_from_subscribed_accounts"},
                "disputes" => $data["disputes"] ?? $accountNotificationSetting->{"disputes"},
                "deposits" => $data["deposits"] ?? $accountNotificationSetting->{"deposits"},
                "withdrawals" => $data["withdrawals"] ?? $accountNotificationSetting->{"withdrawals"},
                "transfers" => $data["transfers"] ?? $accountNotificationSetting->{"transfers"},
                "new_subscribers" => $data["new_subscribers"] ?? $accountNotificationSetting->{"new_subscribers"},
                "post_mentions" => $data["post_mentions"] ?? $accountNotificationSetting->{"post_mentions"},
            ]);

            $result = $updatedAccountPrivacy;
        } catch (\Exception $exception) {
            log_debug(exception: $exception, prefix: 'AccountNotificationSettingService::updateNotificationSettings');
            $result = null;
        }

        return $result;
    }
}
