<?php

namespace App\RequestRules\Api;

class WalletRules
{
    /**
     * Set wallet pin
     *
     * @return string[]
     */
    public static function setPin(): array
    {
        return [
            'wallet_pin' => ['required', 'string', 'min:' . config('torryme.constants.wallet_pin_length'), 'max:' . config('torryme.constants.wallet_pin_length')],
        ];
    }

    /**
     * Update wallet pin
     *
     * @return string[][]
     */
    public static function updatePin(): array
    {
        return [
            'wallet_pin' => ['required', 'string', 'min:' . config('torryme.constants.wallet_pin_length'), 'max:' . config('torryme.constants.wallet_pin_length')],
            'old_wallet_pin' => ['required', 'string', 'min:' . config('torryme.constants.wallet_pin_length'), 'max:' . config('torryme.constants.wallet_pin_length')],
        ];
    }

    /**
     * CHeck wallet pin
     *
     * @return \string[][]
     */
    public static function checkPin(): array
    {
        return [
            'wallet_pin' => ['required', 'string', 'min:' . config('torryme.constants.wallet_pin_length'), 'max:' . config('torryme.constants.wallet_pin_length')],
        ];
    }

    /**
     * @return string[]
     */
    public static function findByWalletNumber(): array
    {
        return [
            'wallet_number' => 'required|string|exists:wallets,wallet_number',
        ];
    }

    /**
     * @return string[]
     */
    public static function transferToAccount(): array
    {
        return [
            'wallet_pin' => ['required', 'string', 'min:' . config('torryme.constants.wallet_pin_length'), 'max:' . config('torryme.constants.wallet_pin_length')],
            'source_amount' => 'required|numeric|gt:0',
            'recipient_id' => 'required|numeric|exists:users,id',
        ];
    }

    /**
     * Deposit rule
     *
     * @return array
     */
    public static function deposit(): array
    {
        return [
            'wallet_pin' => ['required', 'string', 'min:' . config('torryme.constants.wallet_pin_length'), 'max:' . config('torryme.constants.wallet_pin_length')],
            'deposit_amount' => 'required|numeric|gt:0',
            'external_account_id' => 'required|numeric|exists:external_accounts,id',
        ];
    }

    /**
     * Withdrawal rule
     *
     * @return array
     */
    public static function withdraw(): array
    {
        return  [
            'wallet_pin' => ['required', 'string', 'min:' . config('torryme.constants.wallet_pin_length'), 'max:' . config('torryme.constants.wallet_pin_length')],
            'withdrawal_amount' => 'required|numeric|gt:0',
            'external_account_id' => 'required|numeric|exists:external_accounts,id',
        ];
    }
}
