<?php

namespace App\RequestRules\Api;

class UserTelephoneRequestRule
{

   /**
    * Add telephone rule
    *
    * @return string[]
    */
   public static function createRules(): array
   {
      return [
         'telephone' => 'required|phone:AUTO',
         'password' => 'required|string',
      ];
   }

   /**
    * Edit rules
    *
    * @return string[]
    */
   public static function editRules(): array
   {
      return [
         'old_telephone' => 'required|phone:AUTO',
         'new_telephone' => 'required|phone:AUTO',
         'password' => 'required|string',
      ];
   }

   /**
    * Mark telephone number as primary
    * @return string[]
    */
   public static function marKPrimaryRules(): array
   {
      return [
         'telephone' => 'required|phone:AUTO',
         'password' => 'required|string',
      ];
   }

   /**
    * Deactivate rules
    *
    * @return string[]
    */
   public static function deactivateRules(): array
   {
      return [
         'telephone' => 'required|phone:AUTO',
         'password' => 'required|string',
      ];
   }

   /**
    * Delete rules
    *
    * @return string[]
    */
   public static function deleteRules(): array
   {
      return [
         'telephone' => 'required|phone:AUTO',
         'password' => 'required|string',
      ];
   }

   /**
    * Verify rules
    *
    * @return string[]
    */
   public static function verifyRules(): array
   {
      return [
         'telephone' => 'required|phone:AUTO',
         'otp' => 'required|string',
      ];
   }
}
