<?php

namespace App\RequestRules\Api;

class DisputeRequestRules
{
   /**
    * New message rules
    *
    * @return string[]
    */
   public static function newMessageRules(): array
   {
      return [
         'message' => 'required|string|filled',
         'dispute_uuid' => 'required|exists:disputes,uuid',
      ];
   }

    /**
     * Creation rules
     *
     * @return string[]
     */
    public static function creationRules(): array
    {
        return [
            'transaction_id' => 'required|exists:transactions,id',
            'dispute_type_id' => 'required|exists:dispute_types,id',
            'label_color' => 'required|string',
            'dispute_name' => 'nullable|string',
        ];
    }
}
