<?php

namespace App\RequestRules\Api;

class ContentRestrictionRequestRules
{
    /**
     * Add restriction rules
     *
     * @return string[]
     */
    public static function add(): array
    {
        return [
            'keywords' => 'sometimes|array',
            'categories' => 'sometimes|array',
        ];
    }

    /**
     * Delete content restriction
     *
     * @return string[]
     */
    public static function delete(): array
    {
        return [
            'content_restriction_id' => 'required|numeric|exists:content_restrictions,id',
        ];
    }

}
