<?php

namespace App\RequestRules\Api;

class ChatRequestRules
{
   /**
    * Send message rules
    *
    * @return string[]
    */
   public static function sendMessageRules(): array
   {
      $baseRules = [
         'chat_name' => 'required|string',
         'receiver' => 'required|string|exists:users,telephone',
      ];

      if(request()->hasFile('attachment')) {
         return [
            ...$baseRules,
            'message' => 'nullable|string',
         ];
      }

      return [
         ...$baseRules,
         'message' => 'required|string|filled',
      ];
   }
}
