<?php

namespace App\RequestRules\Api;


class CartItemRequestRules
{
    /**
     * Create cart rues
     *
     * @return string[]
     */
     public static function create(): array
    {
        return [
            'product_id' => 'required|numeric|exists:products,id',
            'product_quantity' => 'required|numeric|gt:0',
            'cart_item_attributes' => 'nullable|array'
        ];
    }

    /**
     * Update cart rules
     *
     * @return string[]
     */
    public static function update(): array
    {
        return [
            'cart_item_id' => 'required|numeric|exists:cart_items,id',
            'product_id' => 'required|numeric|exists:products,id',
            'product_quantity' => 'required|numeric|gt:0',
            'cart_item_attributes' => 'nullable|array'
        ];
    }

}
