<?php

namespace App\RequestRules\Api;

class BusinessRules
{

    /**
     * Create rules
     *
     * @return string[]
     */
    public static function create(): array {
        return [
            'business_category_id' => 'required|numeric|exists:business_categories,id',
            'designation' => 'required|string|filled',
            'address' => 'required|string|filled',
            'geographic_location' => 'nullable|string',
            'country_code' => 'nullable|string',
            'city_name' => 'nullable|string',
        ];
    }
}
