<?php

namespace App\RequestRules\Api;

use App\Enums\GenericStatusEnum;

class AccountNotificationSettingRequestRules
{
    /**
     * Edit account notification setting rules
     *
     * @return \string[][]
     */
    public static function editAccountNotification(): array
    {
        return [
            'enable_push_notification' => [
                'sometimes',
                'in:' . implode(",", array(GenericStatusEnum::enable->value, GenericStatusEnum::disable->value))
            ],
            'new_order' => [
                'sometimes',
                'in:' . implode(",", array(GenericStatusEnum::enable->value, GenericStatusEnum::disable->value))
            ],
            'likes' => [
                'sometimes',
                'in:' . implode(",", array(GenericStatusEnum::enable->value, GenericStatusEnum::disable->value))
            ],
            'comments' => [
                'sometimes',
                'in:' . implode(",", array(GenericStatusEnum::enable->value, GenericStatusEnum::disable->value))
            ],
            'shares' => [
                'sometimes',
                'in:' . implode(",", array(GenericStatusEnum::enable->value, GenericStatusEnum::disable->value))
            ],
            'reviews' => [
                'sometimes',
                'in:' . implode(",", array(GenericStatusEnum::enable->value, GenericStatusEnum::disable->value))
            ],
            'direct_messages' => [
                'sometimes',
                'in:' . implode(",", array(GenericStatusEnum::enable->value, GenericStatusEnum::disable->value))
            ],
            'post_from_subscribed_accounts' => [
                'sometimes',
                'in:' . implode(",", array(GenericStatusEnum::enable->value, GenericStatusEnum::disable->value))
            ],
            'live_stream_from_subscribed_accounts' => [
                'sometimes',
                'in:' . implode(",", array(GenericStatusEnum::enable->value, GenericStatusEnum::disable->value))
            ],
            'disputes' => [
                'sometimes',
                'in:' . implode(",", array(GenericStatusEnum::enable->value, GenericStatusEnum::disable->value))
            ],
            'deposits' => [
                'sometimes',
                'in:' . implode(",", array(GenericStatusEnum::enable->value, GenericStatusEnum::disable->value))
            ],
            'withdrawals' => [
                'sometimes',
                'in:' . implode(",", array(GenericStatusEnum::enable->value, GenericStatusEnum::disable->value))
            ],
            'transfers' => [
                'sometimes',
                'in:' . implode(",", array(GenericStatusEnum::enable->value, GenericStatusEnum::disable->value))
            ],
            'new_subscribers' => [
                'sometimes',
                'in:' . implode(",", array(GenericStatusEnum::enable->value, GenericStatusEnum::disable->value))
            ],
            'post_mentions' => [
                'sometimes',
                'in:' . implode(",", array(GenericStatusEnum::enable->value, GenericStatusEnum::disable->value))
            ],
        ];
    }
}
