<?php

namespace App\Notifications;

use App\Enums\NotificationType;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Notification;
use NotificationChannels\OneSignal\OneSignalChannel;
use NotificationChannels\OneSignal\OneSignalMessage;

class SendRealtimeMessageNotification extends Notification implements ShouldQueue
{
    use Queueable;

    /**
     * MessageSent constructor.
     *
     * @param array $message
     */
    public function __construct(private array $message)
    {
        $this->queue = 'notification';
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return string[]
     */
    public function via(): array
    {
        return [OneSignalChannel::class];
    }

    /**
     * To one signal
     *
     * @return OneSignalMessage
     */
    public function toOneSignal(): OneSignalMessage
    {
        $emitter = $this->message['emitter'];

        return
            OneSignalMessage::create()
                ->setSubject(sprintf(
                    "%s (%s)",
                    ucwords($emitter->{'user'}->{'business'}?->{'designation'} ?? $emitter->{'user'}->smallName()),
                    $emitter->{'user'}->{'user_name'},
                ))
                ->setBody($this->message['message'])
                ->setData('data', array(
                   'notification_type' => NotificationType::chat->{'value'},
                    'uuid' => $this->message['uuid'],
                    'chat_uuid' => $this->message['chat']['uuid']
                ));
    }
}
