<?php

namespace App\Notifications;

use App\Enums\ChannelEnum;
use App\Enums\NotificationType;
use App\Models\Dispute;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Notification;
use NotificationChannels\OneSignal\OneSignalChannel;
use NotificationChannels\OneSignal\OneSignalMessage;

class SendDisputeInvitationNotification extends Notification implements ShouldQueue
{
   use Queueable;

   /**
    * MessageSent constructor.
    *
    * @param Dispute $dispute
    */
   public function __construct(private Dispute $dispute)
   {
      $this->queue = 'notification';
   }

   /**
    * Get the notification's delivery channels.
    *
    * @return string[]
    */
   public function via(): array
   {
      return [OneSignalChannel::class];
   }

   /**
    * To one signal
    *
    * @return OneSignalMessage
    */
   public function toOneSignal(): OneSignalMessage
   {
      $creator = $this->dispute->{'creator'};
      $senderLabel = ucwords($creator->{'business'}?->{'designation'} ?? $creator->smallName());

      return
         OneSignalMessage::create()
            ->setSubject(sprintf("Dispute - %s (%s)", $senderLabel, $creator->{'user_name'},))
            ->setBody("Invite you for dispute")
            ->setData('data', array(
               'notification_type' => NotificationType::dispute->{'value'},
               'event' => ChannelEnum::disputeInvitationEvent->{'value'},
               'dispute_uuid' => $this->dispute->{'uuid'},
            ));
   }
}
