<?php

namespace App\Notifications;

use App\Enums\ChannelEnum;
use App\Enums\CommunityMembershipRequestStatusEnum;
use App\Enums\NotificationType;
use App\Models\CommunityMembershipRequest;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Notification;
use NotificationChannels\OneSignal\OneSignalChannel;
use NotificationChannels\OneSignal\OneSignalMessage;

class CommunityMemberShipStatusNotification extends Notification implements ShouldQueue
{
   use Queueable;

   /**
    * MessageSent constructor.
    *
    * @param CommunityMembershipRequest $membershipRequest
    */
   public function __construct(private CommunityMembershipRequest $membershipRequest)
   {
      $this->queue = 'notification';
   }

   /**
    * Get the notification's delivery channels.
    *
    * @return string[]
    */
   public function via(): array
   {
      return [OneSignalChannel::class];
   }

   /**
    * To one signal
    *
    * @return OneSignalMessage
    */
   public function toOneSignal(): OneSignalMessage
   {
      $community = $this->membershipRequest->{'community'};

      $message = '';
      if ($this->membershipRequest->{'status'} === CommunityMembershipRequestStatusEnum::approved->value) {
         $message = 'Your membership request has been accepted';
      }

      if ($this->membershipRequest->{'status'} === CommunityMembershipRequestStatusEnum::declined->value) {
         $message = 'Your membership request has been rejected';
      }

      return
         OneSignalMessage::create()
            ->setSubject($community->{'designation'})
            ->setBody($message)
            ->setData('data', array(
               'notification_type' => NotificationType::community->{'value'},
               'event' => ChannelEnum::memberShipStatus->{'value'},
            ));
   }
}
