<?php

namespace App\Models;

use App\Services\UserVerificationService;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class UserVerification extends Model
{
    use HasFactory, SoftDeletes;
    use UserVerificationService;

    static string $prefixDir = "user_verification_";

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'user_verifications';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'first_name',
        'last_name',
        'date_of_birth',
        'user_name',
        'status',
        'verified_at',
        'rejected_at',
        'rejection_reason',

        'request_verification_user_id',
        'treated_by_user_id',
        'country_id',
    ];

    /**
     * The attributes excluded from the model's JSON form.
     *
     * @var array
     */
    protected $hidden = [
        'request_verification_user_id',
        'treated_by_user_id',
        'country_id'
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        'declined_at' => 'datetime',
        'verified_at' => 'datetime',
    ];

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = ['created_at', 'updated_at', 'deleted_at', 'verified_at', 'rejected_at'];

    /**
     * The "booting" method of the model.
     *
     * @return void
     */
    public static function boot(): void
    {
        parent::boot();
    }

    // Relations
}
