<?php

namespace App\Models;

use App\Concerns\RealtimeMessageBroadcastConcern;
use App\Concerns\RealtimeMessageNotificationConcern;
use App\Services\RealtimeMessageService;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class RealtimeMessage extends Model
{
   use HasFactory;
   use SoftDeletes;
   use RealtimeMessageService;
   use RealtimeMessageBroadcastConcern, RealtimeMessageNotificationConcern;

   /**
    * The database table used by the model.
    *
    * @var string
    */
   protected $table = 'realtime_messages';

   /**
    * Attributes that should be mass-assignable.
    *
    * @var array
    */
   protected $fillable = [
      'uuid',
      'message',
      'sent_at',

      'chat_id',
      'emitter_participant_id',
      'receiver_participant_id',
      'respond_to_message_id',
   ];

   /**
    * The attributes excluded from the model's JSON form.
    *
    * @var array
    */
   protected $hidden = [
      'id',
      'chat_id',
      'emitter_participant_id',
      'receiver_participant_id',
      'respond_to_message_id',
   ];

   /**
    * The attributes that should be casted to native types.
    *
    * @var array
    */
   protected $casts = [
      "sent_at" => 'datetime',
   ];

   /**
    * The attributes that should be mutated to dates.
    *
    * @var array
    */
   protected $dates = ['created_at', 'updated_at', 'deleted_at', 'sent_at'];

   /**
    * The "booting" method of the model.
    *
    * @return void
    */
   public static function boot(): void
   {
      parent::boot();
   }

   /** Attributes used outside the class to create modify the resource */

   /**
    * Full path for assets
    *
    * @return string
    */
   public function buildAttachmentDir(): string
   {
      return sprintf(Chat::$prefixDir . "%s", $this->{'chat_id'});
   }

   /** Relations */

   public function chat(): \Illuminate\Database\Eloquent\Relations\BelongsTo
   {
      return $this->belongsTo(Chat::class);
   }

   public function emitter(): \Illuminate\Database\Eloquent\Relations\BelongsTo
   {
      return $this->belongsTo(RealtimeParticipant::class, 'emitter_participant_id');
   }

   public function receiver(): \Illuminate\Database\Eloquent\Relations\BelongsTo
   {
      return $this->belongsTo(RealtimeParticipant::class, 'receiver_participant_id');
   }

   public function realtimeMessageAttachment(): \Illuminate\Database\Eloquent\Relations\HasOne
   {
      return $this->hasOne(RealtimeMessageAttachment::class);
   }
}
