<?php

namespace App\Models;

use App\Http\Controllers\Api\Platform\StorageFileController;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ProductRatingAttachments extends Model
{
    use HasFactory, SoftDeletes;
    // use ProductRatingAttachmentsService;

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'product_rating_attachments';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'path',

        'product_rating_id',
    ];

    /**
     * The attributes excluded from the model's JSON form.
     *
     * @var array
     */
    protected $hidden = [
        'product_rating_id',
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [];

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = ['created_at', 'updated_at', 'deleted_at'];

    /**
     * The accessors to append to the model's array form.
     *
     * @var array
     */
    protected $appends = ['attachment_url'];

    /**
     * The "booting" method of the model.
     *
     * @return void
     */
    public static function boot(): void
    {
        parent::boot();
    }

    /**  Append attributes */

    public function getAttachmentUrlAttribute(): ?string
    {
        if (filled($this->{'path'})) {
            return route('serve.doc', [
                'resourceId' => $this->{'id'},
                'q' => StorageFileController::ratingAttachment,
                'file' => $this->{'path'}
            ]);
        }

        return null;
    }

    /** Attributes used outside the class to create modify the resource */

    /** Relations */
}
