<?php

namespace App\Models;

use App\Services\MessageDeliveryHistoryService;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class MessageDeliveryHistory extends Model
{
    use HasFactory, SoftDeletes;
    use MessageDeliveryHistoryService;

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'message_delivery_history';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'delivered_at',

        'message_id',
        'participant_id',
    ];

    /**
     * The attributes excluded from the model's JSON form.
     *
     * @var array
     */
    protected $hidden = [
        'id',
        'message_id',
        'participant_id',
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [];

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = ['created_at', 'updated_at', 'deleted_at'];

    /**
     * The "booting" method of the model.
     *
     * @return void
     */
    public static function boot(): void
    {
        parent::boot();
    }

    /**  Append attributes */

    /** Attributes used outside the class to create modify the resource */

    /** Relations */

    public function participant(): \Illuminate\Database\Eloquent\Relations\BelongsTo
    {
        return $this->belongsTo(RealtimeParticipant::class, 'participant_id');
    }
}
