<?php

namespace App\Models;

use App\Services\ExternalAccountService;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ExternalAccount extends Model
{
    use HasFactory, SoftDeletes;
    use ExternalAccountService;

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'external_accounts';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'telephone',
        'email',
        'card_number',
        'card_pin',
        'card_expiry_date',
        'status',
        'payment_gateway',
        'operation_direction',
        'name',

        'user_id',
    ];

    /**
     * The attributes excluded from the model's JSON form.
     *
     * @var array
     */
    protected $hidden = [
        'user_id',
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        "card_expiry_date" => "datetime"
    ];

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = ['card_expiry_date', 'created_at', 'updated_at', 'deleted_at'];

    /**
     * The "booting" method of the model.
     *
     * @return void
     */
    public static function boot()
    {
        parent::boot();
    }

    public function user(): \Illuminate\Database\Eloquent\Relations\hasMany
    {
        return $this->hasMany(User::class);
    }
}
